/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.plain.AtomicDoubleFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public class DoubleArrayIndexFieldData
extends AbstractIndexFieldData<AtomicNumericFieldData>
implements IndexNumericFieldData {
    private final CircuitBreakerService breakerService;

    public DoubleArrayIndexFieldData(Index index, Settings indexSettings, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.DOUBLE;
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
        final LeafReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        AtomicNumericFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker("fielddata"));
        if (terms == null) {
            data = AtomicDoubleFieldData.empty(reader.maxDoc());
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        DoubleArray values = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(128L);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        boolean success = false;
        try {
            AtomicNumericFieldData atomicNumericFieldData;
            try (OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), acceptableTransientOverheadRatio);){
                BytesRef term;
                BytesRefIterator iter = builder.buildFromTerms(this.getNumericType().wrapTermsEnum(terms.iterator()));
                long numTerms = 0L;
                while ((term = iter.next()) != null) {
                    values = BigArrays.NON_RECYCLING_INSTANCE.grow(values, numTerms + 1L);
                    values.set(numTerms++, NumericUtils.sortableLongToDouble(NumericUtils.prefixCodedToLong(term)));
                }
                final DoubleArray finalValues = values = BigArrays.NON_RECYCLING_INSTANCE.resize(values, numTerms);
                final Ordinals build = builder.build(this.fieldDataType.getSettings());
                RandomAccessOrds ordinals = build.ordinals();
                if (FieldData.isMultiValued(ordinals) || IndexFieldData.CommonSettings.getMemoryStorageHint(this.fieldDataType) == IndexFieldData.CommonSettings.MemoryStorageFormat.ORDINALS) {
                    long ramBytesUsed = build.ramBytesUsed() + values.ramBytesUsed();
                    data = new AtomicDoubleFieldData(ramBytesUsed){

                        @Override
                        public SortedNumericDoubleValues getDoubleValues() {
                            return DoubleArrayIndexFieldData.withOrdinals(build, finalValues, reader.maxDoc());
                        }

                        @Override
                        public Collection<Accountable> getChildResources() {
                            ArrayList<Accountable> resources = new ArrayList<Accountable>();
                            resources.add(Accountables.namedAccountable("ordinals", build));
                            resources.add(Accountables.namedAccountable("values", finalValues));
                            return Collections.unmodifiableList(resources);
                        }
                    };
                } else {
                    long ordinalsSize;
                    final BitSet set = builder.buildDocsWithValuesSet();
                    long singleValuesArraySize = (long)(reader.maxDoc() * 8) + (set == null ? 0L : set.ramBytesUsed());
                    long uniqueValuesArraySize = values.ramBytesUsed();
                    if (uniqueValuesArraySize + (ordinalsSize = build.ramBytesUsed()) < singleValuesArraySize) {
                        long ramBytesUsed = build.ramBytesUsed() + values.ramBytesUsed();
                        success = true;
                        data = new AtomicDoubleFieldData(ramBytesUsed){

                            @Override
                            public SortedNumericDoubleValues getDoubleValues() {
                                return DoubleArrayIndexFieldData.withOrdinals(build, finalValues, reader.maxDoc());
                            }

                            @Override
                            public Collection<Accountable> getChildResources() {
                                ArrayList<Accountable> resources = new ArrayList<Accountable>();
                                resources.add(Accountables.namedAccountable("ordinals", build));
                                resources.add(Accountables.namedAccountable("values", finalValues));
                                return Collections.unmodifiableList(resources);
                            }
                        };
                        AtomicDoubleFieldData atomicDoubleFieldData = data;
                        return atomicDoubleFieldData;
                    }
                    int maxDoc = reader.maxDoc();
                    final DoubleArray sValues = BigArrays.NON_RECYCLING_INSTANCE.newDoubleArray(maxDoc);
                    for (int i = 0; i < maxDoc; ++i) {
                        ordinals.setDocument(i);
                        long ordinal = ordinals.nextOrd();
                        if (ordinal == -1L) continue;
                        sValues.set(i, values.get(ordinal));
                    }
                    assert (sValues.size() == (long)maxDoc);
                    long ramBytesUsed = sValues.ramBytesUsed() + (set == null ? 0L : set.ramBytesUsed());
                    data = new AtomicDoubleFieldData(ramBytesUsed){

                        @Override
                        public SortedNumericDoubleValues getDoubleValues() {
                            return DoubleArrayIndexFieldData.singles(sValues, set);
                        }

                        @Override
                        public Collection<Accountable> getChildResources() {
                            ArrayList<Accountable> resources = new ArrayList<Accountable>();
                            resources.add(Accountables.namedAccountable("values", sValues));
                            resources.add(Accountables.namedAccountable("missing bitset", set));
                            return Collections.unmodifiableList(resources);
                        }
                    };
                    success = true;
                }
                success = true;
                atomicNumericFieldData = data;
            }
            return atomicNumericFieldData;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.ramBytesUsed());
            }
        }
    }

    @Override
    protected AtomicNumericFieldData empty(int maxDoc) {
        return AtomicDoubleFieldData.empty(maxDoc);
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    private static SortedNumericDoubleValues withOrdinals(Ordinals ordinals, final DoubleArray values, int maxDoc) {
        final RandomAccessOrds ords = ordinals.ordinals();
        final SortedDocValues singleOrds = DocValues.unwrapSingleton(ords);
        if (singleOrds != null) {
            NumericDoubleValues singleValues = new NumericDoubleValues(){

                @Override
                public double get(int docID) {
                    int ord = singleOrds.getOrd(docID);
                    if (ord >= 0) {
                        return values.get(singleOrds.getOrd(docID));
                    }
                    return 0.0;
                }
            };
            return FieldData.singleton(singleValues, DocValues.docsWithValue(ords, maxDoc));
        }
        return new SortedNumericDoubleValues(){

            @Override
            public double valueAt(int index) {
                return values.get(ords.ordAt(index));
            }

            @Override
            public void setDocument(int doc) {
                ords.setDocument(doc);
            }

            @Override
            public int count() {
                return ords.cardinality();
            }
        };
    }

    private static SortedNumericDoubleValues singles(final DoubleArray values, Bits set) {
        NumericDoubleValues numValues = new NumericDoubleValues(){

            @Override
            public double get(int docID) {
                return values.get(docID);
            }
        };
        return FieldData.singleton(numValues, set);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, Settings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new DoubleArrayIndexFieldData(index, indexSettings, fieldType.names(), fieldType.fieldDataType(), cache, breakerService);
        }
    }
}

