/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappedFieldTypeReference;

class FieldTypeLookup
implements Iterable<MappedFieldType> {
    private static final Function<MappedFieldTypeReference, MappedFieldType> UNWRAPPER = new Function<MappedFieldTypeReference, MappedFieldType>(){

        @Override
        public MappedFieldType apply(MappedFieldTypeReference ref) {
            return ref.get();
        }
    };
    private final CopyOnWriteHashMap<String, MappedFieldTypeReference> fullNameToFieldType;
    private final CopyOnWriteHashMap<String, Set<String>> fullNameToTypes;
    private final CopyOnWriteHashMap<String, MappedFieldTypeReference> indexNameToFieldType;
    private final CopyOnWriteHashMap<String, Set<String>> indexNameToTypes;

    public FieldTypeLookup() {
        this.fullNameToFieldType = new CopyOnWriteHashMap();
        this.fullNameToTypes = new CopyOnWriteHashMap();
        this.indexNameToFieldType = new CopyOnWriteHashMap();
        this.indexNameToTypes = new CopyOnWriteHashMap();
    }

    private FieldTypeLookup(CopyOnWriteHashMap<String, MappedFieldTypeReference> fullName, CopyOnWriteHashMap<String, Set<String>> fullNameToTypes, CopyOnWriteHashMap<String, MappedFieldTypeReference> indexName, CopyOnWriteHashMap<String, Set<String>> indexNameToTypes) {
        this.fullNameToFieldType = fullName;
        this.fullNameToTypes = fullNameToTypes;
        this.indexNameToFieldType = indexName;
        this.indexNameToTypes = indexNameToTypes;
    }

    private static CopyOnWriteHashMap<String, Set<String>> addType(CopyOnWriteHashMap<String, Set<String>> map, String key, String type) {
        Set<String> types = map.get(key);
        if (types == null) {
            return map.copyAndPut(key, Collections.singleton(type));
        }
        if (types.contains(type)) {
            return map;
        }
        Set<String> newTypes = new HashSet<String>(types.size() + 1);
        newTypes.addAll(types);
        newTypes.add(type);
        assert (newTypes.size() == types.size() + 1);
        newTypes = Collections.unmodifiableSet(newTypes);
        return map.copyAndPut(key, newTypes);
    }

    public FieldTypeLookup copyAndAddAll(String type, Collection<FieldMapper> newFieldMappers) {
        Objects.requireNonNull(type, "type must not be null");
        if ("_default_".equals(type)) {
            throw new IllegalArgumentException("Default mappings should not be added to the lookup");
        }
        CopyOnWriteHashMap<String, MappedFieldTypeReference> fullName = this.fullNameToFieldType;
        CopyOnWriteHashMap<String, Set<String>> fullNameToTypes = this.fullNameToTypes;
        CopyOnWriteHashMap<String, MappedFieldTypeReference> indexName = this.indexNameToFieldType;
        CopyOnWriteHashMap<String, Set<String>> indexNameToTypes = this.indexNameToTypes;
        for (FieldMapper fieldMapper : newFieldMappers) {
            MappedFieldType fieldType = fieldMapper.fieldType();
            MappedFieldTypeReference fullNameRef = fullName.get(fieldType.names().fullName());
            MappedFieldTypeReference indexNameRef = indexName.get(fieldType.names().indexName());
            if (fullNameRef == null && indexNameRef == null) {
                fullName = fullName.copyAndPut(fieldType.names().fullName(), fieldMapper.fieldTypeReference());
                indexName = indexName.copyAndPut(fieldType.names().indexName(), fieldMapper.fieldTypeReference());
            } else if (fullNameRef == null) {
                fullName = fullName.copyAndPut(fieldType.names().fullName(), indexNameRef);
                indexNameRef.set(fieldMapper.fieldType());
                fieldMapper.setFieldTypeReference(indexNameRef);
            } else if (indexNameRef == null) {
                indexName = indexName.copyAndPut(fieldType.names().indexName(), fullNameRef);
                fullNameRef.set(fieldMapper.fieldType());
                fieldMapper.setFieldTypeReference(fullNameRef);
            } else if (fullNameRef == indexNameRef) {
                fullNameRef.set(fieldMapper.fieldType());
                fieldMapper.setFieldTypeReference(fullNameRef);
            } else {
                throw new IllegalStateException("insane mappings found. field " + fieldType.names().fullName() + " maps across types to field " + fieldType.names().indexName());
            }
            fullNameToTypes = FieldTypeLookup.addType(fullNameToTypes, fieldType.names().fullName(), type);
            indexNameToTypes = FieldTypeLookup.addType(indexNameToTypes, fieldType.names().indexName(), type);
        }
        return new FieldTypeLookup(fullName, fullNameToTypes, indexName, indexNameToTypes);
    }

    private static boolean beStrict(String type, Set<String> types, boolean updateAllTypes) {
        assert (types.size() >= 1);
        if (updateAllTypes) {
            return false;
        }
        return types.size() != 1 || !types.contains(type);
    }

    public void checkCompatibility(String type, Collection<FieldMapper> fieldMappers, boolean updateAllTypes) {
        for (FieldMapper fieldMapper : fieldMappers) {
            MappedFieldTypeReference indexNameRef;
            MappedFieldTypeReference ref = this.fullNameToFieldType.get(fieldMapper.fieldType().names().fullName());
            if (ref != null) {
                ArrayList<String> conflicts = new ArrayList<String>();
                Set<String> types = this.fullNameToTypes.get(fieldMapper.fieldType().names().fullName());
                boolean strict = FieldTypeLookup.beStrict(type, types, updateAllTypes);
                ref.get().checkCompatibility(fieldMapper.fieldType(), conflicts, strict);
                if (!conflicts.isEmpty()) {
                    throw new IllegalArgumentException("Mapper for [" + fieldMapper.fieldType().names().fullName() + "] conflicts with existing mapping in other types:\n" + ((Object)conflicts).toString());
                }
            }
            if ((indexNameRef = this.indexNameToFieldType.get(fieldMapper.fieldType().names().indexName())) == null) continue;
            ArrayList<String> conflicts = new ArrayList<String>();
            Set<String> types = this.indexNameToTypes.get(fieldMapper.fieldType().names().indexName());
            boolean strict = FieldTypeLookup.beStrict(type, types, updateAllTypes);
            indexNameRef.get().checkCompatibility(fieldMapper.fieldType(), conflicts, strict);
            if (conflicts.isEmpty()) continue;
            throw new IllegalArgumentException("Mapper for [" + fieldMapper.fieldType().names().fullName() + "] conflicts with mapping with the same index name in other types" + ((Object)conflicts).toString());
        }
    }

    public MappedFieldType get(String field) {
        MappedFieldTypeReference ref = this.fullNameToFieldType.get(field);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public Set<String> getTypes(String field) {
        Set<String> types = this.fullNameToTypes.get(field);
        if (types == null) {
            types = Collections.emptySet();
        }
        return types;
    }

    public MappedFieldType getByIndexName(String field) {
        MappedFieldTypeReference ref = this.indexNameToFieldType.get(field);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public Set<String> getTypesByIndexName(String field) {
        Set<String> types = this.indexNameToTypes.get(field);
        if (types == null) {
            types = Collections.emptySet();
        }
        return types;
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        HashSet<String> fields = Sets.newHashSet();
        for (MappedFieldType fieldType : this) {
            if (Regex.simpleMatch(pattern, fieldType.names().fullName())) {
                fields.add(fieldType.names().indexName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldType.names().indexName())) continue;
            fields.add(fieldType.names().indexName());
        }
        return fields;
    }

    public Collection<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = Sets.newHashSet();
        for (MappedFieldType fieldType : this) {
            if (Regex.simpleMatch(pattern, fieldType.names().fullName())) {
                fields.add(fieldType.names().fullName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldType.names().indexName())) continue;
            fields.add(fieldType.names().fullName());
        }
        return fields;
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        return Iterators.transform(this.fullNameToFieldType.values().iterator(), UNWRAPPER);
    }
}

