/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import com.carrotsearch.hppc.ObjectArrayList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class BinaryFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "binary";
    private static final ParseField COMPRESS = new ParseField("compress", new String[0]).withAllDeprecated("no replacement, implemented at the codec level");
    private static final ParseField COMPRESS_THRESHOLD = new ParseField("compress_threshold", new String[0]).withAllDeprecated("no replacement");

    protected BinaryFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.fieldType().stored() && !this.fieldType().hasDocValues()) {
            return;
        }
        byte[] value = context.parseExternalValue(byte[].class);
        if (value == null) {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().binaryValue();
        }
        if (value == null) {
            return;
        }
        if (this.fieldType().stored()) {
            fields.add(new Field(this.fieldType().names().indexName(), value, (FieldType)this.fieldType()));
        }
        if (this.fieldType().hasDocValues()) {
            CustomBinaryDocValuesField field = (CustomBinaryDocValuesField)context.doc().getByKey(this.fieldType().names().indexName());
            if (field == null) {
                field = new CustomBinaryDocValuesField(this.fieldType().names().indexName(), value);
                context.doc().addWithKey(this.fieldType().names().indexName(), field);
            } else {
                field.add(value);
            }
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class CustomBinaryDocValuesField
    extends NumberFieldMapper.CustomNumericDocValuesField {
        private final ObjectArrayList<byte[]> bytesList = new ObjectArrayList();
        private int totalSize = 0;

        public CustomBinaryDocValuesField(String name, byte[] bytes) {
            super(name);
            this.add(bytes);
        }

        public void add(byte[] bytes) {
            this.bytesList.add(bytes);
            this.totalSize += bytes.length;
        }

        @Override
        public BytesRef binaryValue() {
            try {
                CollectionUtils.sortAndDedup(this.bytesList);
                int size = this.bytesList.size();
                byte[] bytes = new byte[this.totalSize + (size + 1) * 5];
                ByteArrayDataOutput out = new ByteArrayDataOutput(bytes);
                out.writeVInt(size);
                for (int i = 0; i < size; ++i) {
                    byte[] value = this.bytesList.get(i);
                    int valueLength = value.length;
                    out.writeVInt(valueLength);
                    out.writeBytes(value, 0, valueLength);
                }
                return new BytesRef(bytes, 0, out.getPosition());
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get binary value", (Throwable)e, new Object[0]);
            }
        }
    }

    static final class BinaryFieldType
    extends MappedFieldType {
        private boolean tryUncompressing = false;

        public BinaryFieldType() {
        }

        protected BinaryFieldType(BinaryFieldType ref) {
            super(ref);
            this.tryUncompressing = ref.tryUncompressing;
        }

        @Override
        public MappedFieldType clone() {
            return new BinaryFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            BinaryFieldType that = (BinaryFieldType)o;
            return Objects.equals(this.tryUncompressing, that.tryUncompressing);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.tryUncompressing);
        }

        @Override
        public String typeName() {
            return BinaryFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            BinaryFieldType other = (BinaryFieldType)fieldType;
            if (this.tryUncompressing() != other.tryUncompressing()) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [try_uncompressing] (IMPOSSIBLE)");
            }
        }

        public boolean tryUncompressing() {
            return this.tryUncompressing;
        }

        public void setTryUncompressing(boolean tryUncompressing) {
            this.checkIfFrozen();
            this.tryUncompressing = tryUncompressing;
        }

        @Override
        public BytesReference value(Object value) {
            BytesReference bytes;
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                bytes = new BytesArray((BytesRef)value);
            } else if (value instanceof BytesReference) {
                bytes = (BytesReference)value;
            } else if (value instanceof byte[]) {
                bytes = new BytesArray((byte[])value);
            } else {
                try {
                    bytes = new BytesArray(Base64.decode(value.toString()));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to convert bytes", (Throwable)e, new Object[0]);
                }
            }
            try {
                if (this.tryUncompressing) {
                    return CompressorFactory.uncompressIfNeeded(bytes);
                }
                return bytes;
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
            }
        }

        @Override
        public Object valueForSearch(Object value) {
            return this.value(value);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.binaryField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1) || !parserContext.parseFieldMatcher().match(fieldName, COMPRESS) && !parserContext.parseFieldMatcher().match(fieldName, COMPRESS_THRESHOLD)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, BinaryFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public BinaryFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            ((BinaryFieldType)this.fieldType).setTryUncompressing(context.indexCreatedVersion().before(Version.V_2_0_0_beta1));
            return new BinaryFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new BinaryFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

