/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericIntegerAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class ShortFieldMapper
extends NumberFieldMapper {
    public static final String CONTENT_TYPE = "short";
    public static final int DEFAULT_PRECISION_STEP = 8;

    protected ShortFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, indexSettings, multiFields, copyTo);
    }

    @Override
    public ShortFieldType fieldType() {
        return (ShortFieldType)super.fieldType();
    }

    private static short parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof BytesRef) {
            return Short.parseShort(((BytesRef)value).utf8ToString());
        }
        return Short.parseShort(value.toString());
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        short value;
        float boost = this.fieldType().boost();
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue();
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.fieldType().nullValue() == null) {
                        return;
                    }
                    value = this.fieldType().nullValue();
                } else {
                    value = Short.parseShort(sExternalValue);
                }
            } else {
                value = ((Number)externalValue).shortValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.fieldType().names().fullName(), Short.toString(value), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue();
                if (this.fieldType().nullValueAsString() != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().names().fullName(), this.fieldType().nullValueAsString(), boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                Short objValue = this.fieldType().nullValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = parser.shortValue((Boolean)this.coerce.value());
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return;
                }
                value = objValue;
            } else {
                value = parser.shortValue((Boolean)this.coerce.value());
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().names().fullName(), parser.text(), boost);
                }
            }
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            CustomShortNumericField field = new CustomShortNumericField(value, this.fieldType());
            field.setBoost(boost);
            fields.add(field);
        }
        if (this.fieldType().hasDocValues()) {
            this.addDocValue(context, fields, value);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 8) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", (Object)this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static class CustomShortNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final short number;

        public CustomShortNumericField(short number, NumberFieldMapper.NumberFieldType fieldType) {
            super(number, fieldType);
            this.number = number;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) throws IOException {
            if (this.fieldType().indexOptions() != IndexOptions.NONE) {
                return this.getCachedStream().setIntValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Short.toString(this.number);
        }
    }

    static final class ShortFieldType
    extends NumberFieldMapper.NumberFieldType {
        public ShortFieldType() {
            super(FieldType.NumericType.INT);
        }

        protected ShortFieldType(ShortFieldType ref) {
            super(ref);
        }

        @Override
        public NumberFieldMapper.NumberFieldType clone() {
            return new ShortFieldType(this);
        }

        @Override
        public String typeName() {
            return ShortFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Short nullValue() {
            return (Short)super.nullValue();
        }

        @Override
        public Short value(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof BytesRef) {
                return Numbers.bytesToShort((BytesRef)value);
            }
            return Short.parseShort(value.toString());
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded(ShortFieldMapper.parseValue(value), 0, bytesRef);
            return bytesRef.get();
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return NumericRangeQuery.newIntRange(this.names().indexName(), this.numericPrecisionStep(), lowerTerm == null ? null : Integer.valueOf(ShortFieldMapper.parseValue(lowerTerm)), upperTerm == null ? null : Integer.valueOf(ShortFieldMapper.parseValue(upperTerm)), includeLower, includeUpper);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
            short iValue = ShortFieldMapper.parseValue(value);
            short iSim = fuzziness.asShort();
            return NumericRangeQuery.newIntRange(this.names().indexName(), this.numericPrecisionStep(), iValue - iSim, iValue + iSim, true, true);
        }

        @Override
        public FieldStats stats(Terms terms, int maxDoc) throws IOException {
            long minValue = NumericUtils.getMinInt(terms).intValue();
            long maxValue = NumericUtils.getMaxInt(terms).intValue();
            return new FieldStats.Long(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), minValue, maxValue);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.shortField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(XContentMapValues.nodeShortValue(propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, ShortFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, 8);
            this.builder = this;
        }

        @Override
        public ShortFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            ShortFieldMapper fieldMapper = new ShortFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            return (ShortFieldMapper)fieldMapper.includeInAll(this.includeInAll);
        }

        @Override
        protected NamedAnalyzer makeNumberAnalyzer(int precisionStep) {
            String name = precisionStep == Integer.MAX_VALUE ? "_short/max" : "_short/" + precisionStep;
            return new NamedAnalyzer(name, new NumericIntegerAnalyzer(precisionStep));
        }

        @Override
        protected int maxPrecisionStep() {
            return 32;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final MappedFieldType FIELD_TYPE = new ShortFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

