/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.geo.BaseGeoPointFieldMapper;
import org.elasticsearch.index.mapper.object.ArrayValueMapperParser;

public class GeoPointFieldMapperLegacy
extends BaseGeoPointFieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "geo_point";
    protected Explicit<Boolean> coerce;

    public static Builder parse(Builder builder, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
        boolean indexCreatedBeforeV2_0 = parserContext.indexVersionCreated().before(Version.V_2_0_0);
        Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (indexCreatedBeforeV2_0 && propName.equals("validate")) {
                builder.ignoreMalformed = !XContentMapValues.nodeBooleanValue(propNode);
                iterator.remove();
                continue;
            }
            if (indexCreatedBeforeV2_0 && propName.equals("validate_lon")) {
                builder.ignoreMalformed = !XContentMapValues.nodeBooleanValue(propNode);
                iterator.remove();
                continue;
            }
            if (indexCreatedBeforeV2_0 && propName.equals("validate_lat")) {
                builder.ignoreMalformed = !XContentMapValues.nodeBooleanValue(propNode);
                iterator.remove();
                continue;
            }
            if (propName.equals("coerce")) {
                builder.coerce = XContentMapValues.nodeBooleanValue(propNode);
                iterator.remove();
                continue;
            }
            if (indexCreatedBeforeV2_0 && propName.equals("normalize")) {
                builder.coerce = XContentMapValues.nodeBooleanValue(propNode);
                iterator.remove();
                continue;
            }
            if (indexCreatedBeforeV2_0 && propName.equals("normalize_lat")) {
                builder.coerce = XContentMapValues.nodeBooleanValue(propNode);
                iterator.remove();
                continue;
            }
            if (!indexCreatedBeforeV2_0 || !propName.equals("normalize_lon")) continue;
            builder.coerce = XContentMapValues.nodeBooleanValue(propNode);
            iterator.remove();
        }
        return builder;
    }

    public GeoPointFieldMapperLegacy(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, ContentPath.Type pathType, DoubleFieldMapper latMapper, DoubleFieldMapper lonMapper, StringFieldMapper geoHashMapper, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, pathType, latMapper, lonMapper, geoHashMapper, multiFields, ignoreMalformed, copyTo);
        this.coerce = coerce;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        GeoPointFieldMapperLegacy gpfmMergeWith = (GeoPointFieldMapperLegacy)mergeWith;
        if (gpfmMergeWith.coerce.explicit() && this.coerce.explicit() && this.coerce.value() != gpfmMergeWith.coerce.value()) {
            throw new IllegalArgumentException("mapper [" + this.fieldType().names().fullName() + "] has different [coerce]");
        }
        if (gpfmMergeWith.coerce.explicit()) {
            this.coerce = gpfmMergeWith.coerce;
        }
    }

    @Override
    protected void parse(ParseContext context, GeoPoint point, String geoHash) throws IOException {
        IndexableField field;
        boolean validPoint = false;
        if (!this.coerce.value().booleanValue() && !((Boolean)this.ignoreMalformed.value()).booleanValue()) {
            if (point.lat() > 90.0 || point.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "] for " + this.name());
            }
            if (point.lon() > 180.0 || point.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "] for " + this.name());
            }
            validPoint = true;
        }
        if (this.coerce.value().booleanValue() && !validPoint) {
            GeoUtils.normalizePoint(point, true, true);
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            field = new Field(this.fieldType().names().indexName(), Double.toString(point.lat()) + ',' + Double.toString(point.lon()), (FieldType)this.fieldType());
            context.doc().add(field);
        }
        super.parse(context, point, geoHash);
        if (this.fieldType().hasDocValues()) {
            field = (CustomGeoPointDocValuesField)context.doc().getByKey(this.fieldType().names().indexName());
            if (field == null) {
                field = new CustomGeoPointDocValuesField(this.fieldType().names().indexName(), point.lat(), point.lon());
                context.doc().addWithKey(this.fieldType().names().indexName(), field);
            } else {
                ((CustomGeoPointDocValuesField)field).add(point.lat(), point.lon());
            }
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", (Object)this.coerce.value());
        }
    }

    public static class CustomGeoPointDocValuesField
    extends NumberFieldMapper.CustomNumericDocValuesField {
        private final ObjectHashSet<GeoPoint> points = new ObjectHashSet(2);

        public CustomGeoPointDocValuesField(String name, double lat, double lon) {
            super(name);
            this.points.add(new GeoPoint(lat, lon));
        }

        public void add(double lat, double lon) {
            this.points.add(new GeoPoint(lat, lon));
        }

        @Override
        public BytesRef binaryValue() {
            byte[] bytes = new byte[this.points.size() * 16];
            int off = 0;
            Iterator<ObjectCursor<GeoPoint>> it = this.points.iterator();
            while (it.hasNext()) {
                GeoPoint point = (GeoPoint)it.next().value;
                ByteUtils.writeDoubleLE(point.getLat(), bytes, off);
                ByteUtils.writeDoubleLE(point.getLon(), bytes, off + 8);
                off += 16;
            }
            return new BytesRef(bytes);
        }
    }

    public static final class Encoding {
        private static final int MAX_NUM_BYTES = 14;
        private static final Encoding[] INSTANCES = new Encoding[15];
        private final DistanceUnit.Distance precision;
        private final int numBytes;
        private final int numBytesPerCoordinate;
        private final double factor;

        public static final Encoding of(int numBytesPerValue) {
            Encoding instance = INSTANCES[numBytesPerValue];
            if (instance == null) {
                throw new IllegalStateException("No encoding for " + numBytesPerValue + " bytes per value");
            }
            return instance;
        }

        public static final Encoding of(DistanceUnit.Distance precision) {
            for (Encoding encoding : INSTANCES) {
                if (encoding == null || encoding.precision().compareTo(precision) > 0) continue;
                return encoding;
            }
            return INSTANCES[14];
        }

        private Encoding(int numBytes) {
            assert (numBytes >= 1 && numBytes <= 14);
            assert ((numBytes & 1) == 0);
            this.numBytes = numBytes;
            this.numBytesPerCoordinate = numBytes / 2;
            this.factor = Math.pow(2.0, -this.numBytesPerCoordinate * 8 + 9);
            assert ((double)(1L << this.numBytesPerCoordinate * 8 - 1) * this.factor > 180.0 && (double)(1L << this.numBytesPerCoordinate * 8 - 2) * this.factor < 180.0) : this.numBytesPerCoordinate + " " + this.factor;
            this.precision = numBytes == 14 ? new DistanceUnit.Distance(0.0, DistanceUnit.DEFAULT) : new DistanceUnit.Distance(GeoDistance.PLANE.calculate(0.0, 0.0, this.factor / 2.0, this.factor / 2.0, DistanceUnit.DEFAULT), DistanceUnit.DEFAULT);
        }

        public DistanceUnit.Distance precision() {
            return this.precision;
        }

        public final int numBytes() {
            return this.numBytes;
        }

        public int numBitsPerCoordinate() {
            return this.numBytesPerCoordinate << 3;
        }

        public long encodeCoordinate(double lat) {
            return Math.round((lat + 180.0) / this.factor);
        }

        public double decodeCoordinate(long bits) {
            return (double)bits * this.factor - 180.0;
        }

        private void encodeBits(long bits, byte[] out, int offset) {
            for (int i = 0; i < this.numBytesPerCoordinate; ++i) {
                out[offset++] = (byte)bits;
                bits >>>= 8;
            }
            assert (bits == 0L);
        }

        private long decodeBits(byte[] in, int offset) {
            long r = (long)in[offset++] & 0xFFL;
            for (int i = 1; i < this.numBytesPerCoordinate; ++i) {
                r = ((long)in[offset++] & 0xFFL) << i * 8;
            }
            return r;
        }

        public void encode(double lat, double lon, byte[] out, int offset) {
            this.encodeBits(this.encodeCoordinate(lat), out, offset);
            this.encodeBits(this.encodeCoordinate(lon), out, offset + this.numBytesPerCoordinate);
        }

        public GeoPoint decode(byte[] in, int offset, GeoPoint out) {
            long latBits = this.decodeBits(in, offset);
            long lonBits = this.decodeBits(in, offset + this.numBytesPerCoordinate);
            return this.decode(latBits, lonBits, out);
        }

        public GeoPoint decode(long latBits, long lonBits, GeoPoint out) {
            double lat = this.decodeCoordinate(latBits);
            double lon = this.decodeCoordinate(lonBits);
            return out.reset(lat, lon);
        }

        static {
            for (int numBytes = 2; numBytes <= 14; numBytes += 2) {
                Encoding.INSTANCES[numBytes] = new Encoding(numBytes);
            }
        }
    }

    public static class Builder
    extends BaseGeoPointFieldMapper.Builder<Builder, GeoPointFieldMapperLegacy> {
        private Boolean coerce;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.coerce", Defaults.COERCE.value()), false);
            }
            return Defaults.COERCE;
        }

        @Override
        public GeoPointFieldMapperLegacy build(Mapper.BuilderContext context, String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, ContentPath.Type pathType, DoubleFieldMapper latMapper, DoubleFieldMapper lonMapper, StringFieldMapper geoHashMapper, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, FieldMapper.CopyTo copyTo) {
            fieldType.setTokenized(false);
            this.setupFieldType(context);
            fieldType.setHasDocValues(false);
            defaultFieldType.setHasDocValues(false);
            return new GeoPointFieldMapperLegacy(simpleName, fieldType, defaultFieldType, indexSettings, pathType, latMapper, lonMapper, geoHashMapper, multiFields, ignoreMalformed, this.coerce(context), copyTo);
        }

        @Override
        public GeoPointFieldMapperLegacy build(Mapper.BuilderContext context) {
            return (GeoPointFieldMapperLegacy)super.build(context);
        }
    }

    public static class Defaults
    extends BaseGeoPointFieldMapper.Defaults {
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(false, false);
        public static final BaseGeoPointFieldMapper.GeoPointFieldType FIELD_TYPE = new BaseGeoPointFieldMapper.GeoPointFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }

    public static class Names
    extends BaseGeoPointFieldMapper.Names {
        public static final String COERCE = "coerce";
    }
}

