/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.Version;
import org.elasticsearch.action.TimestampParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NumericDateAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;

public class TimestampFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_timestamp";
    public static final String CONTENT_TYPE = "_timestamp";
    public static final String DEFAULT_DATE_TIME_FORMAT = "epoch_millis||strictDateOptionalTime";
    private EnabledAttributeMapper enabledState;
    private final String path;
    private final String defaultTimestamp;
    private final Boolean ignoreMissing;

    private static FormatDateTimeFormatter getDateTimeFormatter(Settings indexSettings) {
        Version indexCreated = Version.indexCreated(indexSettings);
        if (indexCreated.onOrAfter(Version.V_2_0_0_beta1)) {
            return Defaults.DATE_TIME_FORMATTER;
        }
        return Defaults.DATE_TIME_FORMATTER_BEFORE_2_0;
    }

    private static MappedFieldType chooseFieldType(Settings settings, MappedFieldType existing) {
        if (existing != null) {
            return existing;
        }
        return Version.indexCreated(settings).onOrAfter(Version.V_2_0_0_beta1) ? Defaults.FIELD_TYPE : Defaults.PRE_20_FIELD_TYPE;
    }

    private TimestampFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(TimestampFieldMapper.chooseFieldType(indexSettings, existing).clone(), TimestampFieldMapper.chooseFieldType(indexSettings, null), Defaults.ENABLED, Defaults.PATH, "now", null, indexSettings);
    }

    private TimestampFieldMapper(MappedFieldType fieldType, MappedFieldType defaultFieldType, EnabledAttributeMapper enabledState, String path, String defaultTimestamp, Boolean ignoreMissing, Settings indexSettings) {
        super("_timestamp", fieldType, defaultFieldType, indexSettings);
        this.enabledState = enabledState;
        this.path = path;
        this.defaultTimestamp = defaultTimestamp;
        this.ignoreMissing = ignoreMissing;
    }

    @Override
    public TimestampFieldType fieldType() {
        return (TimestampFieldType)super.fieldType();
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public String path() {
        return this.path;
    }

    public String defaultTimestamp() {
        return this.defaultTimestamp;
    }

    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (this.enabledState.enabled) {
            long timestamp = context.sourceToParse().timestamp();
            if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored() && !this.fieldType().hasDocValues()) {
                context.ignoredValue(this.fieldType().names().indexName(), String.valueOf(timestamp));
            }
            if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
                fields.add(new LongFieldMapper.CustomLongNumericField(timestamp, (MappedFieldType)this.fieldType()));
            }
            if (this.fieldType().hasDocValues()) {
                fields.add(new NumericDocValuesField(this.fieldType().names().indexName(), timestamp));
            }
        }
    }

    @Override
    protected String contentType() {
        return "_timestamp";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String defaultDateFormat;
        boolean indexedDefault;
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        boolean indexed = this.fieldType().indexOptions() != IndexOptions.NONE;
        boolean bl = indexedDefault = Defaults.FIELD_TYPE.indexOptions() != IndexOptions.NONE;
        if (!includeDefaults && indexed == indexedDefault && !this.hasCustomFieldDataSettings() && this.fieldType().stored() == Defaults.FIELD_TYPE.stored() && this.enabledState == Defaults.ENABLED && this.path == Defaults.PATH && this.fieldType().dateTimeFormatter().format().equals(Defaults.DATE_TIME_FORMATTER.format()) && "now".equals(this.defaultTimestamp) && this.defaultFieldType.hasDocValues() == this.fieldType().hasDocValues()) {
            return builder;
        }
        builder.startObject("_timestamp");
        if (includeDefaults || this.enabledState != Defaults.ENABLED) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (this.indexCreatedBefore2x && (includeDefaults || indexed != indexedDefault || this.fieldType().tokenized() != Defaults.FIELD_TYPE.tokenized())) {
            builder.field("index", TimestampFieldMapper.indexTokenizeOptionToString(indexed, this.fieldType().tokenized()));
        }
        if (this.indexCreatedBefore2x && (includeDefaults || this.fieldType().stored() != Defaults.PRE_20_FIELD_TYPE.stored())) {
            builder.field("store", this.fieldType().stored());
        }
        if (this.indexCreatedBefore2x) {
            this.doXContentDocValues(builder, includeDefaults);
        }
        if (this.indexCreatedBefore2x && (includeDefaults || this.path != Defaults.PATH)) {
            builder.field("path", this.path);
        }
        String string = defaultDateFormat = this.indexCreatedBefore2x ? Defaults.DATE_TIME_FORMATTER_BEFORE_2_0.format() : Defaults.DATE_TIME_FORMATTER.format();
        if (includeDefaults || !this.fieldType().dateTimeFormatter().format().equals(defaultDateFormat)) {
            builder.field("format", this.fieldType().dateTimeFormatter().format());
        }
        if (includeDefaults || !"now".equals(this.defaultTimestamp)) {
            builder.field("default", this.defaultTimestamp);
        }
        if (includeDefaults || this.ignoreMissing != null) {
            builder.field("ignore_missing", (Object)this.ignoreMissing);
        }
        if (this.indexCreatedBefore2x && (includeDefaults || this.hasCustomFieldDataSettings())) {
            builder.field("fielddata", (Object)this.fieldType().fieldDataType().getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        TimestampFieldMapper timestampFieldMapperMergeWith = (TimestampFieldMapper)mergeWith;
        super.doMerge(mergeWith, updateAllTypes);
        if (timestampFieldMapperMergeWith.enabledState != this.enabledState && !timestampFieldMapperMergeWith.enabledState.unset()) {
            this.enabledState = timestampFieldMapperMergeWith.enabledState;
        }
        if (timestampFieldMapperMergeWith.defaultTimestamp() == null && this.defaultTimestamp == null) {
            return;
        }
        ArrayList<String> conflicts = new ArrayList<String>();
        if (this.defaultTimestamp == null) {
            conflicts.add("Cannot update default in _timestamp value. Value is null now encountering " + timestampFieldMapperMergeWith.defaultTimestamp());
        } else if (timestampFieldMapperMergeWith.defaultTimestamp() == null) {
            conflicts.add("Cannot update default in _timestamp value. Value is \" + defaultTimestamp.toString() + \" now encountering null");
        } else if (!timestampFieldMapperMergeWith.defaultTimestamp().equals(this.defaultTimestamp)) {
            conflicts.add("Cannot update default in _timestamp value. Value is " + this.defaultTimestamp.toString() + " now encountering " + timestampFieldMapperMergeWith.defaultTimestamp());
        }
        if (this.path != null) {
            if (!this.path.equals(timestampFieldMapperMergeWith.path())) {
                conflicts.add("Cannot update path in _timestamp value. Value is " + this.path + " path in merged mapping is " + (timestampFieldMapperMergeWith.path() == null ? "missing" : timestampFieldMapperMergeWith.path()));
            }
        } else if (timestampFieldMapperMergeWith.path() != null) {
            conflicts.add("Cannot update path in _timestamp value. Value is " + this.path + " path in merged mapping is missing");
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("Conflicts: " + conflicts);
        }
    }

    public static final class TimestampFieldType
    extends DateFieldMapper.DateFieldType {
        public TimestampFieldType() {
        }

        protected TimestampFieldType(TimestampFieldType ref) {
            super(ref);
        }

        @Override
        public TimestampFieldType clone() {
            return new TimestampFieldType(this);
        }

        @Override
        public Object valueForSearch(Object value) {
            return this.value(value);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.mapperService().fullName("_timestamp"));
            if (parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                TypeParsers.parseField(builder, builder.name, node, parserContext);
            }
            boolean defaultSet = false;
            Boolean ignoreMissing = null;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    EnabledAttributeMapper enabledState = XContentMapValues.nodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
                    builder.enabled(enabledState);
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("path") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                    builder.path(fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("default")) {
                    if (fieldNode == null) {
                        if (!parserContext.indexVersionCreated().onOrAfter(Version.V_1_4_0_Beta1) || !parserContext.indexVersionCreated().before(Version.V_1_5_0)) throw new TimestampParsingException("default timestamp can not be set to null");
                        builder.ignoreMissing(false);
                    } else {
                        builder.defaultTimestamp(fieldNode.toString());
                        defaultSet = true;
                    }
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("ignore_missing")) continue;
                ignoreMissing = XContentMapValues.nodeBooleanValue(fieldNode);
                builder.ignoreMissing(ignoreMissing);
                iterator.remove();
            }
            if (!defaultSet || ignoreMissing == null || ignoreMissing.booleanValue()) return builder;
            throw new TimestampParsingException("default timestamp can not be set with ignore_missing set to false");
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new TimestampFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, TimestampFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;
        private String path = Defaults.PATH;
        private String defaultTimestamp = "now";
        private boolean explicitStore = false;
        private Boolean ignoreMissing = null;

        public Builder(MappedFieldType existing) {
            super("_timestamp", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
            if (existing != null) {
                this.explicitStore = true;
            }
        }

        @Override
        public DateFieldMapper.DateFieldType fieldType() {
            return (DateFieldMapper.DateFieldType)this.fieldType;
        }

        public Builder enabled(EnabledAttributeMapper enabledState) {
            this.enabledState = enabledState;
            return (Builder)this.builder;
        }

        public Builder path(String path) {
            this.path = path;
            return (Builder)this.builder;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.fieldType().setDateTimeFormatter(dateTimeFormatter);
            return this;
        }

        public Builder defaultTimestamp(String defaultTimestamp) {
            this.defaultTimestamp = defaultTimestamp;
            return (Builder)this.builder;
        }

        public Builder ignoreMissing(boolean ignoreMissing) {
            this.ignoreMissing = ignoreMissing;
            return (Builder)this.builder;
        }

        @Override
        public Builder store(boolean store) {
            this.explicitStore = true;
            return (Builder)super.store(store);
        }

        @Override
        public TimestampFieldMapper build(Mapper.BuilderContext context) {
            if (!this.explicitStore && context.indexCreatedVersion().before(Version.V_2_0_0_beta1)) {
                this.fieldType.setStored(false);
            }
            if (this.fieldType().dateTimeFormatter().equals(Defaults.DATE_TIME_FORMATTER)) {
                this.fieldType().setDateTimeFormatter(TimestampFieldMapper.getDateTimeFormatter(context.indexSettings()));
            }
            this.setupFieldType(context);
            return new TimestampFieldMapper(this.fieldType, this.defaultFieldType, this.enabledState, this.path, this.defaultTimestamp, this.ignoreMissing, context.indexSettings());
        }
    }

    public static class Defaults
    extends DateFieldMapper.Defaults {
        public static final String NAME = "_timestamp";
        public static final TimestampFieldType PRE_20_FIELD_TYPE;
        public static final TimestampFieldType FIELD_TYPE;
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER;
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER_BEFORE_2_0;
        public static final EnabledAttributeMapper ENABLED;
        public static final String PATH;
        public static final String DEFAULT_TIMESTAMP = "now";

        static {
            FIELD_TYPE = new TimestampFieldType();
            DATE_TIME_FORMATTER = Joda.forPattern(TimestampFieldMapper.DEFAULT_DATE_TIME_FORMAT);
            DATE_TIME_FORMATTER_BEFORE_2_0 = Joda.forPattern("epoch_millis||dateOptionalTime");
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setNumericPrecisionStep(16);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_timestamp"));
            FIELD_TYPE.setDateTimeFormatter(DATE_TIME_FORMATTER);
            FIELD_TYPE.setIndexAnalyzer(NumericDateAnalyzer.buildNamedAnalyzer(DATE_TIME_FORMATTER, 16));
            FIELD_TYPE.setSearchAnalyzer(NumericDateAnalyzer.buildNamedAnalyzer(DATE_TIME_FORMATTER, Integer.MAX_VALUE));
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.freeze();
            PRE_20_FIELD_TYPE = FIELD_TYPE.clone();
            PRE_20_FIELD_TYPE.setStored(false);
            PRE_20_FIELD_TYPE.setHasDocValues(false);
            PRE_20_FIELD_TYPE.setDateTimeFormatter(DATE_TIME_FORMATTER_BEFORE_2_0);
            PRE_20_FIELD_TYPE.setIndexAnalyzer(NumericDateAnalyzer.buildNamedAnalyzer(DATE_TIME_FORMATTER_BEFORE_2_0, 16));
            PRE_20_FIELD_TYPE.setSearchAnalyzer(NumericDateAnalyzer.buildNamedAnalyzer(DATE_TIME_FORMATTER_BEFORE_2_0, Integer.MAX_VALUE));
            PRE_20_FIELD_TYPE.freeze();
            ENABLED = EnabledAttributeMapper.UNSET_DISABLED;
            PATH = null;
        }
    }
}

