/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class BoolQueryParser
implements QueryParser {
    public static final String NAME = "bool";

    @Inject
    public BoolQueryParser(Settings settings) {
        BooleanQuery.setMaxClauseCount(settings.getAsInt("index.query.bool.max_clause_count", settings.getAsInt("indices.query.bool.max_clause_count", (Integer)BooleanQuery.getMaxClauseCount())));
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean disableCoord = false;
        float boost = 1.0f;
        String minimumShouldMatch = null;
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        boolean adjustPureNegative = true;
        String queryName = null;
        String currentFieldName = null;
        block26: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                switch (currentFieldName) {
                    case "must": {
                        query = parseContext.parseInnerQuery();
                        if (query == null) continue block26;
                        clauses.add(new BooleanClause(query, BooleanClause.Occur.MUST));
                        continue block26;
                    }
                    case "should": {
                        query = parseContext.parseInnerQuery();
                        if (query == null) continue block26;
                        clauses.add(new BooleanClause(query, BooleanClause.Occur.SHOULD));
                        if (!parseContext.isFilter() || minimumShouldMatch != null) continue block26;
                        minimumShouldMatch = "1";
                        continue block26;
                    }
                    case "filter": {
                        query = parseContext.parseInnerFilter();
                        if (query == null) continue block26;
                        clauses.add(new BooleanClause(query, BooleanClause.Occur.FILTER));
                        continue block26;
                    }
                    case "must_not": 
                    case "mustNot": {
                        query = parseContext.parseInnerFilter();
                        if (query == null) continue block26;
                        clauses.add(new BooleanClause(query, BooleanClause.Occur.MUST_NOT));
                        continue block26;
                    }
                }
                throw new QueryParsingException(parseContext, "[bool] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                block27: while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    switch (currentFieldName) {
                        case "must": {
                            query = parseContext.parseInnerQuery();
                            if (query == null) continue block27;
                            clauses.add(new BooleanClause(query, BooleanClause.Occur.MUST));
                            continue block27;
                        }
                        case "should": {
                            query = parseContext.parseInnerQuery();
                            if (query == null) continue block27;
                            clauses.add(new BooleanClause(query, BooleanClause.Occur.SHOULD));
                            if (!parseContext.isFilter() || minimumShouldMatch != null) continue block27;
                            minimumShouldMatch = "1";
                            continue block27;
                        }
                        case "filter": {
                            query = parseContext.parseInnerFilter();
                            if (query == null) continue block27;
                            clauses.add(new BooleanClause(query, BooleanClause.Occur.FILTER));
                            continue block27;
                        }
                        case "must_not": 
                        case "mustNot": {
                            query = parseContext.parseInnerFilter();
                            if (query == null) continue block27;
                            clauses.add(new BooleanClause(query, BooleanClause.Occur.MUST_NOT));
                            continue block27;
                        }
                    }
                    throw new QueryParsingException(parseContext, "bool query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("disable_coord".equals(currentFieldName) || "disableCoord".equals(currentFieldName)) {
                disableCoord = parser.booleanValue();
                continue;
            }
            if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                minimumShouldMatch = parser.textOrNull();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("minimum_number_should_match".equals(currentFieldName) || "minimumNumberShouldMatch".equals(currentFieldName)) {
                minimumShouldMatch = parser.textOrNull();
                continue;
            }
            if ("adjust_pure_negative".equals(currentFieldName) || "adjustPureNegative".equals(currentFieldName)) {
                adjustPureNegative = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[bool] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (clauses.isEmpty()) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        booleanQueryBuilder.setDisableCoord(disableCoord);
        for (BooleanClause clause : clauses) {
            booleanQueryBuilder.add(clause);
        }
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        booleanQuery.setBoost(boost);
        booleanQuery = Queries.applyMinimumShouldMatch(booleanQuery, minimumShouldMatch);
        Query query2 = query = adjustPureNegative ? Queries.fixNegativeQueryIfNeeded(booleanQuery) : booleanQuery;
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

