/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class ConstantScoreQueryParser
implements QueryParser {
    public static final String NAME = "constant_score";
    private static final ParseField INNER_QUERY_FIELD = new ParseField("filter", "query");

    @Inject
    public ConstantScoreQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query filter = null;
        boolean queryFound = false;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, INNER_QUERY_FIELD)) {
                    filter = parseContext.parseInnerFilter();
                    queryFound = true;
                    continue;
                }
                throw new QueryParsingException(parseContext, "[constant_score] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext, "[constant_score] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext, "[constant_score] requires a 'filter' element", new Object[0]);
        }
        if (filter == null) {
            return null;
        }
        filter = new ConstantScoreQuery(filter);
        filter.setBoost(boost);
        return filter;
    }
}

