/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.GeoPointInPolygonQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.geo.BaseGeoPointFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.geo.GeoPolygonQuery;

public class GeoPolygonQueryParser
implements QueryParser {
    public static final String NAME = "geo_polygon";
    public static final String POINTS = "points";

    @Inject
    public GeoPolygonQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoPolygon"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        MappedFieldType fieldType;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        ArrayList<GeoPoint> shell = new ArrayList<GeoPoint>();
        boolean indexCreatedBeforeV2_0 = parseContext.indexVersionCreated().before(Version.V_2_0_0);
        boolean coerce = false;
        boolean ignoreMalformed = false;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (POINTS.equals(currentFieldName)) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                shell.add(GeoUtils.parseGeoPoint(parser));
                            }
                            if (((GeoPoint)shell.get(shell.size() - 1)).equals(shell.get(0))) continue;
                            shell.add((GeoPoint)shell.get(0));
                            continue;
                        }
                        throw new QueryParsingException(parseContext, "[geo_polygon] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new QueryParsingException(parseContext, "[geo_polygon] query does not support token type [" + token.name() + "] under [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (token.isValue()) {
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if ("coerce".equals(currentFieldName) || indexCreatedBeforeV2_0 && "normalize".equals(currentFieldName)) {
                    coerce = parser.booleanValue();
                    if (!coerce) continue;
                    ignoreMalformed = true;
                    continue;
                }
                if ("ignore_malformed".equals(currentFieldName) && !coerce) {
                    ignoreMalformed = parser.booleanValue();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[geo_polygon] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new QueryParsingException(parseContext, "[geo_polygon] unexpected token type [" + token.name() + "]", new Object[0]);
        }
        if (shell.isEmpty()) {
            throw new QueryParsingException(parseContext, "no points defined for geo_polygon query", new Object[0]);
        }
        if (shell.size() < 3) {
            throw new QueryParsingException(parseContext, "too few points defined for geo_polygon query", new Object[0]);
        }
        GeoPoint start = (GeoPoint)shell.get(0);
        if (!start.equals(shell.get(shell.size() - 1))) {
            shell.add(start);
        }
        if (shell.size() < 4) {
            throw new QueryParsingException(parseContext, "too few points defined for geo_polygon query", new Object[0]);
        }
        int shellSize = shell.size();
        if (!indexCreatedBeforeV2_0 && !ignoreMalformed) {
            for (GeoPoint point : shell) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new QueryParsingException(parseContext, "illegal latitude value [{}] for [{}]", point.lat(), NAME);
                }
                if (!(point.lon() > 180.0) && !(point.lon() < -180.0)) continue;
                throw new QueryParsingException(parseContext, "illegal longitude value [{}] for [{}]", point.lon(), NAME);
            }
        }
        if (coerce) {
            for (GeoPoint point : shell) {
                GeoUtils.normalizePoint(point, coerce, coerce);
            }
        }
        if ((fieldType = parseContext.fieldMapper(fieldName)) == null) {
            throw new QueryParsingException(parseContext, "failed to find geo_point field [" + fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof BaseGeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryParsingException(parseContext, "field [" + fieldName + "] is not a geo_point field", new Object[0]);
        }
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.getForField(fieldType);
        if (parseContext.indexVersionCreated().before(Version.V_2_2_0)) {
            query = new GeoPolygonQuery(indexFieldData, shell.toArray(new GeoPoint[shellSize]));
        } else {
            double[] lats = new double[shellSize];
            double[] lons = new double[shellSize];
            for (int i = 0; i < shell.size(); ++i) {
                GeoPoint p = (GeoPoint)shell.get(i);
                lats[i] = p.lat();
                lons[i] = p.lon();
            }
            query = new GeoPointInPolygonQuery(indexFieldData.getFieldNames().indexName(), lons, lats);
        }
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

