/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.geo.GeoShapeFieldMapper;
import org.elasticsearch.index.query.ExistsQueryParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.shape.ShapeFetchService;
import org.elasticsearch.search.internal.SearchContext;

public class GeoShapeQueryParser
implements QueryParser {
    public static final String NAME = "geo_shape";
    private ShapeFetchService fetchService;

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        ConstantScoreQuery query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        ShapeRelation shapeRelation = ShapeRelation.INTERSECTS;
        String strategyName = null;
        ShapeBuilder shape = null;
        String id = null;
        String type = null;
        String index = "shapes";
        String shapePath = "shape";
        String currentFieldName = null;
        float boost = 1.0f;
        String queryName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if ("shape".equals(currentFieldName)) {
                        shape = ShapeBuilder.parse(parser);
                        continue;
                    }
                    if ("strategy".equals(currentFieldName)) {
                        strategyName = parser.text();
                        continue;
                    }
                    if ("relation".equals(currentFieldName)) {
                        shapeRelation = ShapeRelation.getRelationByName(parser.text());
                        if (shapeRelation != null) continue;
                        throw new QueryParsingException(parseContext, "Unknown shape operation [" + parser.text() + " ]", new Object[0]);
                    }
                    if ("indexed_shape".equals(currentFieldName) || "indexedShape".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("id".equals(currentFieldName)) {
                                id = parser.text();
                                continue;
                            }
                            if ("type".equals(currentFieldName)) {
                                type = parser.text();
                                continue;
                            }
                            if ("index".equals(currentFieldName)) {
                                index = parser.text();
                                continue;
                            }
                            if (!"path".equals(currentFieldName)) continue;
                            shapePath = parser.text();
                        }
                        if (id == null) {
                            throw new QueryParsingException(parseContext, "ID for indexed shape not provided", new Object[0]);
                        }
                        if (type == null) {
                            throw new QueryParsingException(parseContext, "Type for indexed shape not provided", new Object[0]);
                        }
                        GetRequest getRequest = new GetRequest(index, type, id);
                        getRequest.copyContextAndHeadersFrom(SearchContext.current());
                        shape = this.fetchService.fetch(getRequest, shapePath);
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[geo_shape] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[geo_shape] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (shape == null) {
            throw new QueryParsingException(parseContext, "No Shape defined", new Object[0]);
        }
        if (shapeRelation == null) {
            throw new QueryParsingException(parseContext, "No Shape Relation defined", new Object[0]);
        }
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType == null) {
            throw new QueryParsingException(parseContext, "Failed to find geo_shape field [" + fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof GeoShapeFieldMapper.GeoShapeFieldType)) {
            throw new QueryParsingException(parseContext, "Field [" + fieldName + "] is not a geo_shape", new Object[0]);
        }
        GeoShapeFieldMapper.GeoShapeFieldType shapeFieldType = (GeoShapeFieldMapper.GeoShapeFieldType)fieldType;
        PrefixTreeStrategy strategy = shapeFieldType.defaultStrategy();
        if (strategyName != null) {
            strategy = shapeFieldType.resolveStrategy(strategyName);
        }
        if (strategy instanceof RecursivePrefixTreeStrategy && shapeRelation == ShapeRelation.DISJOINT) {
            BooleanQuery.Builder bool = new BooleanQuery.Builder();
            Query exists = ExistsQueryParser.newFilter(parseContext, fieldName, null);
            Query intersects = strategy.makeQuery(GeoShapeQueryParser.getArgs(shape, ShapeRelation.INTERSECTS));
            bool.add(exists, BooleanClause.Occur.MUST);
            bool.add(intersects, BooleanClause.Occur.MUST_NOT);
            query = new ConstantScoreQuery(bool.build());
        } else {
            query = new ConstantScoreQuery(strategy.makeQuery(GeoShapeQueryParser.getArgs(shape, shapeRelation)));
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }

    @Inject(optional=true)
    public void setFetchService(@Nullable ShapeFetchService fetchService) {
        this.fetchService = fetchService;
    }

    public static SpatialArgs getArgs(ShapeBuilder shape, ShapeRelation relation) {
        switch (relation) {
            case DISJOINT: {
                return new SpatialArgs(SpatialOperation.IsDisjointTo, shape.build());
            }
            case INTERSECTS: {
                return new SpatialArgs(SpatialOperation.Intersects, shape.build());
            }
            case WITHIN: {
                return new SpatialArgs(SpatialOperation.IsWithin, shape.build());
            }
        }
        throw new IllegalArgumentException("");
    }

    public static class DEFAULTS {
        public static final String INDEX_NAME = "shapes";
        public static final String SHAPE_FIELD_NAME = "shape";
    }
}

