/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.GeoHashUtils;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.geo.BaseGeoPointFieldMapper;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class GeohashCellQuery {
    public static final String NAME = "geohash_cell";
    public static final String NEIGHBORS = "neighbors";
    public static final String PRECISION = "precision";

    public static Query create(QueryParseContext context, BaseGeoPointFieldMapper.GeoPointFieldType fieldType, String geohash, @Nullable List<CharSequence> geohashes) {
        MappedFieldType geoHashMapper = fieldType.geoHashFieldType();
        if (geoHashMapper == null) {
            throw new IllegalArgumentException("geohash filter needs geohash_prefix to be enabled");
        }
        if (geohashes == null || geohashes.size() == 0) {
            return geoHashMapper.termQuery(geohash, context);
        }
        geohashes.add(geohash);
        return geoHashMapper.termsQuery(geohashes, context);
    }

    public static class Parser
    implements QueryParser {
        @Inject
        public Parser() {
        }

        @Override
        public String[] names() {
            return new String[]{GeohashCellQuery.NAME, Strings.toCamelCase(GeohashCellQuery.NAME)};
        }

        @Override
        public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
            XContentParser parser = parseContext.parser();
            String fieldName = null;
            String geohash = null;
            int levels = -1;
            boolean neighbors = false;
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse [{}] query. expected an object but found [{}] instead", new Object[]{GeohashCellQuery.NAME, token});
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String field = parser.text();
                    if (parseContext.isDeprecatedSetting(field)) continue;
                    if (GeohashCellQuery.PRECISION.equals(field)) {
                        token = parser.nextToken();
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            levels = parser.intValue();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_STRING) continue;
                        double meters = DistanceUnit.parse(parser.text(), DistanceUnit.DEFAULT, DistanceUnit.METERS);
                        levels = GeoUtils.geoHashLevelsForPrecision(meters);
                        continue;
                    }
                    if (GeohashCellQuery.NEIGHBORS.equals(field)) {
                        parser.nextToken();
                        neighbors = parser.booleanValue();
                        continue;
                    }
                    fieldName = field;
                    token = parser.nextToken();
                    if (token == XContentParser.Token.VALUE_STRING) {
                        String location = parser.text();
                        if (location.indexOf(",") > 0) {
                            geohash = GeoUtils.parseGeoPoint(parser).geohash();
                            continue;
                        }
                        geohash = location;
                        continue;
                    }
                    geohash = GeoUtils.parseGeoPoint(parser).geohash();
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse [{}] query. unexpected token [{}]", new Object[]{GeohashCellQuery.NAME, token});
            }
            if (geohash == null) {
                throw new QueryParsingException(parseContext, "failed to parse [{}] query. missing geohash value", GeohashCellQuery.NAME);
            }
            MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
            if (fieldType == null) {
                throw new QueryParsingException(parseContext, "failed to parse [{}] query. missing [{}] field [{}]", GeohashCellQuery.NAME, "geo_point", fieldName);
            }
            if (!(fieldType instanceof BaseGeoPointFieldMapper.GeoPointFieldType)) {
                throw new QueryParsingException(parseContext, "failed to parse [{}] query. field [{}] is not a geo_point field", GeohashCellQuery.NAME, fieldName);
            }
            BaseGeoPointFieldMapper.GeoPointFieldType geoFieldType = (BaseGeoPointFieldMapper.GeoPointFieldType)fieldType;
            if (!geoFieldType.isGeoHashPrefixEnabled()) {
                throw new QueryParsingException(parseContext, "failed to parse [{}] query. [geohash_prefix] is not enabled for field [{}]", GeohashCellQuery.NAME, fieldName);
            }
            if (levels > 0) {
                int len = Math.min(levels, geohash.length());
                geohash = geohash.substring(0, len);
            }
            Query filter = neighbors ? GeohashCellQuery.create(parseContext, geoFieldType, geohash, GeoHashUtils.addNeighbors(geohash, new ArrayList(8))) : GeohashCellQuery.create(parseContext, geoFieldType, geohash, null);
            return filter;
        }
    }

    public static class Builder
    extends QueryBuilder {
        private String field;
        private String geohash;
        private int levels = -1;
        private boolean neighbors;

        public Builder(String field) {
            this(field, null, false);
        }

        public Builder(String field, GeoPoint point) {
            this(field, point.geohash(), false);
        }

        public Builder(String field, String geohash) {
            this(field, geohash, false);
        }

        public Builder(String field, String geohash, boolean neighbors) {
            this.field = field;
            this.geohash = geohash;
            this.neighbors = neighbors;
        }

        public Builder point(GeoPoint point) {
            this.geohash = point.getGeohash();
            return this;
        }

        public Builder point(double lat, double lon) {
            this.geohash = GeoHashUtils.stringEncode(lon, lat);
            return this;
        }

        public Builder geohash(String geohash) {
            this.geohash = geohash;
            return this;
        }

        public Builder precision(int levels) {
            this.levels = levels;
            return this;
        }

        public Builder precision(String precision) {
            double meters = DistanceUnit.parse(precision, DistanceUnit.DEFAULT, DistanceUnit.METERS);
            return this.precision(GeoUtils.geoHashLevelsForPrecision(meters));
        }

        public Builder neighbors(boolean neighbors) {
            this.neighbors = neighbors;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(GeohashCellQuery.NAME);
            if (this.neighbors) {
                builder.field(GeohashCellQuery.NEIGHBORS, this.neighbors);
            }
            if (this.levels > 0) {
                builder.field(GeohashCellQuery.PRECISION, this.levels);
            }
            builder.field(this.field, this.geohash);
            builder.endObject();
        }
    }
}

