/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class SimpleQueryParser
extends org.apache.lucene.queryparser.simple.SimpleQueryParser {
    private final Settings settings;

    public SimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags, Settings settings) {
        super(analyzer, weights, flags);
        this.settings = settings;
    }

    private Query rethrowUnlessLenient(RuntimeException e) {
        if (this.settings.lenient()) {
            return null;
        }
        throw e;
    }

    @Override
    public Query newDefaultQuery(String text) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                Query q = this.createBooleanQuery((String)entry.getKey(), text, super.getDefaultOperator());
                if (q == null) continue;
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add(q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    @Override
    public Query newFuzzyQuery(String text, int fuzziness) {
        if (this.settings.lowercaseExpandedTerms()) {
            text = text.toLowerCase(this.settings.locale());
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                FuzzyQuery q = new FuzzyQuery(new Term((String)entry.getKey(), text), fuzziness);
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add(q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    @Override
    public Query newPhraseQuery(String text, int slop) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                Query q = this.createPhraseQuery((String)entry.getKey(), text, slop);
                if (q == null) continue;
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add(q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    @Override
    public Query newPrefixQuery(String text) {
        if (this.settings.lowercaseExpandedTerms()) {
            text = text.toLowerCase(this.settings.locale());
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                if (this.settings.analyzeWildcard()) {
                    Query analyzedQuery = this.newPossiblyAnalyzedQuery((String)entry.getKey(), text);
                    analyzedQuery.setBoost(((Float)entry.getValue()).floatValue());
                    bq.add(analyzedQuery, BooleanClause.Occur.SHOULD);
                    continue;
                }
                PrefixQuery prefix = new PrefixQuery(new Term((String)entry.getKey(), text));
                prefix.setBoost(((Float)entry.getValue()).floatValue());
                bq.add(prefix, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                return this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Query newPossiblyAnalyzedQuery(String field, String termStr) {
        try (TokenStream source = this.getAnalyzer().tokenStream(field, termStr);){
            CachingTokenFilter buffer = new CachingTokenFilter(source);
            buffer.reset();
            TermToBytesRefAttribute termAtt = null;
            int numTokens = 0;
            boolean hasMoreTokens = false;
            termAtt = buffer.getAttribute(TermToBytesRefAttribute.class);
            if (termAtt != null) {
                try {
                    hasMoreTokens = buffer.incrementToken();
                    while (hasMoreTokens) {
                        ++numTokens;
                        hasMoreTokens = buffer.incrementToken();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            buffer.reset();
            if (numTokens == 0) {
                Query query = null;
                return query;
            }
            if (numTokens == 1) {
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                }
                catch (IOException hasNext) {
                    // empty catch block
                }
                PrefixQuery hasNext = new PrefixQuery(new Term(field, BytesRef.deepCopyOf(termAtt.getBytesRef())));
                return hasNext;
            }
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            for (int i = 0; i < numTokens; ++i) {
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                }
                catch (IOException hasNext) {
                    // empty catch block
                }
                bq.add(new BooleanClause(new PrefixQuery(new Term(field, BytesRef.deepCopyOf(termAtt.getBytesRef()))), BooleanClause.Occur.SHOULD));
            }
            BooleanQuery booleanQuery = bq.build();
            return booleanQuery;
        }
        catch (IOException e) {
            return new PrefixQuery(new Term(field, termStr));
        }
    }

    public static class Settings {
        private Locale locale = Locale.ROOT;
        private boolean lowercaseExpandedTerms = true;
        private boolean lenient = false;
        private boolean analyzeWildcard = false;

        public void locale(Locale locale) {
            this.locale = locale;
        }

        public Locale locale() {
            return this.locale;
        }

        public void lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
            this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        }

        public boolean lowercaseExpandedTerms() {
            return this.lowercaseExpandedTerms;
        }

        public void lenient(boolean lenient) {
            this.lenient = lenient;
        }

        public boolean lenient() {
            return this.lenient;
        }

        public void analyzeWildcard(boolean analyzeWildcard) {
            this.analyzeWildcard = analyzeWildcard;
        }

        public boolean analyzeWildcard() {
            return this.analyzeWildcard;
        }
    }
}

