/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class SpanMultiTermQueryParser
implements QueryParser {
    public static final String NAME = "span_multi";
    public static final String MATCH_NAME = "match";

    @Inject
    public SpanMultiTermQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (!MATCH_NAME.equals(parser.currentName()) || token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext, "spanMultiTerm must have [match] multi term query clause", new Object[0]);
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new QueryParsingException(parseContext, "spanMultiTerm must have [match] multi term query clause", new Object[0]);
        }
        Query subQuery = parseContext.parseInnerQuery();
        if (!(subQuery instanceof MultiTermQuery)) {
            throw new QueryParsingException(parseContext, "spanMultiTerm [match] must be of type multi term query", new Object[0]);
        }
        parser.nextToken();
        return new SpanMultiTermQueryWrapper<MultiTermQuery>((MultiTermQuery)subQuery);
    }
}

