/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.XFilteredDocIdSetIterator;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.SuppressForbidden;
import org.elasticsearch.common.lucene.IndexCacheableQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.search.internal.SearchContext;

@Deprecated
@SuppressForbidden(reason="Old p/c queries still use filters")
public class ChildrenConstantScoreQuery
extends IndexCacheableQuery {
    private final IndexParentChildFieldData parentChildIndexFieldData;
    private final Query childQuery;
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final int shortCircuitParentDocSet;
    private final BitSetProducer nonNestedDocsFilter;

    public ChildrenConstantScoreQuery(IndexParentChildFieldData parentChildIndexFieldData, Query childQuery, String parentType, String childType, Filter parentFilter, int shortCircuitParentDocSet, BitSetProducer nonNestedDocsFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.parentFilter = parentFilter;
        this.parentType = parentType;
        this.childType = childType;
        this.childQuery = childQuery;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query childRewritten = this.childQuery.rewrite(reader);
        if (childRewritten != this.childQuery) {
            ChildrenConstantScoreQuery rewritten = new ChildrenConstantScoreQuery(this.parentChildIndexFieldData, childRewritten, this.parentType, this.childType, this.parentFilter, this.shortCircuitParentDocSet, this.nonNestedDocsFilter);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight doCreateWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SearchContext sc = SearchContext.current();
        IndexParentChildFieldData globalIfd = this.parentChildIndexFieldData.loadGlobal((DirectoryReader)searcher.getIndexReader());
        List<LeafReaderContext> leaves = searcher.getIndexReader().leaves();
        if (globalIfd == null || leaves.isEmpty()) {
            return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
        }
        AtomicParentChildFieldData afd = (AtomicParentChildFieldData)globalIfd.load(leaves.get(0));
        SortedDocValues globalValues = afd.getOrdinalsValues(this.parentType);
        long valueCount = globalValues.getValueCount();
        if (valueCount == 0L) {
            return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
        }
        ParentOrdCollector collector = new ParentOrdCollector(globalIfd, valueCount, this.parentType);
        searcher.search(this.childQuery, collector);
        long remaining = collector.foundParents();
        if (remaining == 0L) {
            return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
        }
        Filter shortCircuitFilter = null;
        if (remaining <= (long)this.shortCircuitParentDocSet) {
            shortCircuitFilter = ParentIdsFilter.createShortCircuitFilter(this.nonNestedDocsFilter, sc, this.parentType, collector.values, collector.parentOrds, remaining);
        }
        return new ParentWeight(this, this.parentFilter, globalIfd, shortCircuitFilter, collector, remaining);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ChildrenConstantScoreQuery that = (ChildrenConstantScoreQuery)obj;
        if (!this.childQuery.equals(that.childQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.shortCircuitParentDocSet == that.shortCircuitParentDocSet;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.childQuery.hashCode();
        result = 31 * result + this.childType.hashCode();
        result = 31 * result + this.shortCircuitParentDocSet;
        return result;
    }

    @Override
    public String toString(String field) {
        return "child_filter[" + this.childType + "/" + this.parentType + "](" + this.childQuery + ')';
    }

    private static final class ParentOrdIterator
    extends XFilteredDocIdSetIterator {
        private final LongBitSet parentOrds;
        private final SortedDocValues ordinals;
        private final ParentWeight parentWeight;

        private ParentOrdIterator(DocIdSetIterator innerIterator, LongBitSet parentOrds, SortedDocValues ordinals, ParentWeight parentWeight) {
            super(innerIterator);
            this.parentOrds = parentOrds;
            this.ordinals = ordinals;
            this.parentWeight = parentWeight;
        }

        @Override
        protected boolean match(int doc) {
            if (this.parentWeight.remaining == 0L) {
                throw new CollectionTerminatedException();
            }
            long parentOrd = this.ordinals.getOrd(doc);
            if (parentOrd >= 0L) {
                boolean match = this.parentOrds.get(parentOrd);
                if (match) {
                    this.parentWeight.remaining--;
                }
                return match;
            }
            return false;
        }
    }

    private static final class ParentOrdCollector
    extends SimpleCollector {
        private final LongBitSet parentOrds;
        private final IndexParentChildFieldData indexFieldData;
        private final String parentType;
        private SortedDocValues values;

        private ParentOrdCollector(IndexParentChildFieldData indexFieldData, long maxOrd, String parentType) {
            this.parentOrds = new LongBitSet(maxOrd + 1L);
            this.indexFieldData = indexFieldData;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            int globalOrdinal;
            if (this.values != null && (globalOrdinal = this.values.getOrd(doc)) >= 0) {
                this.parentOrds.set(globalOrdinal);
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.values = ((AtomicParentChildFieldData)this.indexFieldData.load(context)).getOrdinalsValues(this.parentType);
        }

        long foundParents() {
            return this.parentOrds.cardinality();
        }

        @Override
        public boolean needsScores() {
            return false;
        }
    }

    @SuppressForbidden(reason="Old p/c queries still use filters")
    private final class ParentWeight
    extends Weight {
        private final Filter parentFilter;
        private final Filter shortCircuitFilter;
        private final ParentOrdCollector collector;
        private final IndexParentChildFieldData globalIfd;
        private long remaining;
        private float queryNorm;
        private float queryWeight;

        public ParentWeight(Query query, Filter parentFilter, IndexParentChildFieldData globalIfd, Filter shortCircuitFilter, ParentOrdCollector collector, long remaining) {
            super(query);
            this.parentFilter = parentFilter;
            this.globalIfd = globalIfd;
            this.shortCircuitFilter = shortCircuitFilter;
            this.collector = collector;
            this.remaining = remaining;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return Explanation.match(ChildrenConstantScoreQuery.this.getBoost(), "not implemented yet...", new Explanation[0]);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            this.queryWeight = ChildrenConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSetIterator innerIterator;
            if (this.remaining == 0L) {
                return null;
            }
            if (this.shortCircuitFilter != null) {
                DocIdSetIterator iterator;
                DocIdSet docIdSet = this.shortCircuitFilter.getDocIdSet(context, null);
                if (!Lucene.isEmpty(docIdSet) && (iterator = docIdSet.iterator()) != null) {
                    return ConstantScorer.create(iterator, this, this.queryWeight);
                }
                return null;
            }
            DocIdSet parentDocIdSet = this.parentFilter.getDocIdSet(context, null);
            if (!Lucene.isEmpty(parentDocIdSet) && (innerIterator = (parentDocIdSet = BitsFilteredDocIdSet.wrap(parentDocIdSet, context.reader().getLiveDocs())).iterator()) != null) {
                LongBitSet parentOrds = this.collector.parentOrds;
                SortedDocValues globalValues = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(ChildrenConstantScoreQuery.this.parentType);
                if (globalValues != null) {
                    ParentOrdIterator parentIdIterator = new ParentOrdIterator(innerIterator, parentOrds, globalValues, this);
                    return ConstantScorer.create(parentIdIterator, this, this.queryWeight);
                }
            }
            return null;
        }
    }
}

