/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.SuppressForbidden;
import org.elasticsearch.common.lucene.IndexCacheableQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.search.child.ConstantScorer;

@Deprecated
@SuppressForbidden(reason="Old p/c queries still use filters")
public class ParentConstantScoreQuery
extends IndexCacheableQuery {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private Query parentQuery;
    private final String parentType;
    private final Filter childrenFilter;

    public ParentConstantScoreQuery(ParentChildIndexFieldData parentChildIndexFieldData, Query parentQuery, String parentType, Filter childrenFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.parentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewritten = this.parentQuery.rewrite(reader);
        if (parentRewritten != this.parentQuery) {
            ParentConstantScoreQuery rewritten = new ParentConstantScoreQuery(this.parentChildIndexFieldData, parentRewritten, this.parentType, this.childrenFilter);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight doCreateWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        IndexParentChildFieldData globalIfd = this.parentChildIndexFieldData.loadGlobal((DirectoryReader)searcher.getIndexReader());
        List<LeafReaderContext> leaves = searcher.getIndexReader().leaves();
        if (globalIfd == null || leaves.isEmpty()) {
            return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
        }
        AtomicParentChildFieldData afd = (AtomicParentChildFieldData)globalIfd.load(leaves.get(0));
        SortedDocValues globalValues = afd.getOrdinalsValues(this.parentType);
        long maxOrd = globalValues.getValueCount();
        if (maxOrd == 0L) {
            return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
        }
        ParentOrdsCollector collector = new ParentOrdsCollector(globalIfd, maxOrd, this.parentType);
        searcher.search(this.parentQuery, collector);
        if (collector.parentCount() == 0L) {
            return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
        }
        return new ChildrenWeight(this, this.childrenFilter, collector, globalIfd);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.parentQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ParentConstantScoreQuery that = (ParentConstantScoreQuery)obj;
        if (!this.parentQuery.equals(that.parentQuery)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    @Override
    public String toString(String field) {
        return "parent_filter[" + this.parentType + "](" + this.parentQuery + ')';
    }

    private static final class ParentOrdsCollector
    extends SimpleCollector {
        private final LongBitSet parentOrds;
        private final IndexParentChildFieldData globalIfd;
        private final String parentType;
        private SortedDocValues globalOrdinals;

        ParentOrdsCollector(IndexParentChildFieldData globalIfd, long maxOrd, String parentType) {
            this.parentOrds = new LongBitSet(maxOrd);
            this.globalIfd = globalIfd;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            long globalOrd;
            if (this.globalOrdinals != null && (globalOrd = (long)this.globalOrdinals.getOrd(doc)) >= 0L) {
                this.parentOrds.set(globalOrd);
            }
        }

        @Override
        public void doSetNextReader(LeafReaderContext readerContext) throws IOException {
            this.globalOrdinals = ((AtomicParentChildFieldData)this.globalIfd.load(readerContext)).getOrdinalsValues(this.parentType);
        }

        public long parentCount() {
            return this.parentOrds.cardinality();
        }

        @Override
        public boolean needsScores() {
            return false;
        }
    }

    private final class ChildrenDocIdIterator
    extends FilteredDocIdSetIterator {
        private final LongBitSet parentOrds;
        private final SortedDocValues globalOrdinals;

        ChildrenDocIdIterator(DocIdSetIterator innerIterator, LongBitSet parentOrds, SortedDocValues globalOrdinals) {
            super(innerIterator);
            this.parentOrds = parentOrds;
            this.globalOrdinals = globalOrdinals;
        }

        @Override
        protected boolean match(int docId) {
            int globalOrd = this.globalOrdinals.getOrd(docId);
            if (globalOrd >= 0) {
                return this.parentOrds.get(globalOrd);
            }
            return false;
        }
    }

    @SuppressForbidden(reason="Old p/c queries still use filters")
    private final class ChildrenWeight
    extends Weight {
        private final IndexParentChildFieldData globalIfd;
        private final Filter childrenFilter;
        private final LongBitSet parentOrds;
        private float queryNorm;
        private float queryWeight;

        private ChildrenWeight(Query query, Filter childrenFilter, ParentOrdsCollector collector, IndexParentChildFieldData globalIfd) {
            super(query);
            this.globalIfd = globalIfd;
            this.childrenFilter = childrenFilter;
            this.parentOrds = collector.parentOrds;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return Explanation.match(ParentConstantScoreQuery.this.getBoost(), "not implemented yet...", new Explanation[0]);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            this.queryWeight = ParentConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSetIterator innerIterator;
            DocIdSet childrenDocIdSet = this.childrenFilter.getDocIdSet(context, null);
            if (Lucene.isEmpty(childrenDocIdSet)) {
                return null;
            }
            SortedDocValues globalValues = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(ParentConstantScoreQuery.this.parentType);
            if (globalValues != null && (innerIterator = (childrenDocIdSet = BitsFilteredDocIdSet.wrap(childrenDocIdSet, context.reader().getLiveDocs())).iterator()) != null) {
                ChildrenDocIdIterator childrenDocIdIterator = new ChildrenDocIdIterator(innerIterator, this.parentOrds, globalValues);
                return ConstantScorer.create(childrenDocIdIterator, this, this.queryWeight);
            }
            return null;
        }
    }
}

