/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.Callback;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.BufferingTranslogWriter;
import org.elasticsearch.index.translog.ChannelReference;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.ImmutableTranslogReader;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogReader;

public class TranslogWriter
extends TranslogReader {
    public static final String TRANSLOG_CODEC = "translog";
    public static final int VERSION_CHECKSUMS = 1;
    public static final int VERSION_CHECKPOINTS = 2;
    public static final int VERSION = 2;
    protected final ShardId shardId;
    protected final ReleasableLock readLock;
    protected final ReleasableLock writeLock;
    protected volatile long lastSyncedOffset;
    protected volatile int operationCounter;
    protected volatile long writtenOffset;
    private volatile Throwable tragedy;

    public TranslogWriter(ShardId shardId, long generation, ChannelReference channelReference) throws IOException {
        super(generation, channelReference, channelReference.getChannel().position());
        this.shardId = shardId;
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(rwl.readLock());
        this.writeLock = new ReleasableLock(rwl.writeLock());
        this.writtenOffset = channelReference.getChannel().position();
        this.lastSyncedOffset = channelReference.getChannel().position();
    }

    static int getHeaderLength(String translogUUID) {
        return TranslogWriter.getHeaderLength(new BytesRef((CharSequence)translogUUID).length);
    }

    private static int getHeaderLength(int uuidLength) {
        return CodecUtil.headerLength(TRANSLOG_CODEC) + uuidLength + 4;
    }

    public static TranslogWriter create(Type type, ShardId shardId, String translogUUID, long fileGeneration, Path file, Callback<ChannelReference> onClose, int bufferSize, ChannelFactory channelFactory) throws IOException {
        BytesRef ref = new BytesRef(translogUUID);
        int headerLength = TranslogWriter.getHeaderLength(ref.length);
        FileChannel channel = channelFactory.open(file);
        try {
            OutputStreamDataOutput out = new OutputStreamDataOutput(Channels.newOutputStream(channel));
            CodecUtil.writeHeader(out, TRANSLOG_CODEC, 2);
            out.writeInt(ref.length);
            out.writeBytes(ref.bytes, ref.offset, ref.length);
            channel.force(true);
            TranslogWriter.writeCheckpoint(headerLength, 0, file.getParent(), fileGeneration, StandardOpenOption.WRITE);
            TranslogWriter writer = type.create(shardId, fileGeneration, new ChannelReference(file, fileGeneration, channel, onClose), bufferSize);
            return writer;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(channel);
            throw throwable;
        }
    }

    public Throwable getTragicException() {
        return this.tragedy;
    }

    protected final void closeWithTragicEvent(Throwable throwable) throws IOException {
        try (ReleasableLock lock = this.writeLock.acquire();){
            if (this.tragedy == null) {
                this.tragedy = throwable;
            } else if (this.tragedy != throwable) {
                this.tragedy.addSuppressed(throwable);
            }
            this.close();
        }
    }

    public Translog.Location add(BytesReference data) throws IOException {
        long position;
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            position = this.writtenOffset;
            try {
                data.writeTo(this.channel);
            }
            catch (Throwable e) {
                this.closeWithTragicEvent(e);
                throw e;
            }
            this.writtenOffset += (long)data.length();
            ++this.operationCounter;
        }
        return new Translog.Location(this.generation, position, data.length());
    }

    public void updateBufferSize(int bufferSize) throws TranslogException {
    }

    public synchronized void sync() throws IOException {
        if (this.syncNeeded()) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.ensureOpen();
                this.checkpoint(this.writtenOffset, this.operationCounter, this.channelReference);
                this.lastSyncedOffset = this.writtenOffset;
            }
        }
    }

    public boolean syncNeeded() {
        return this.writtenOffset != this.lastSyncedOffset;
    }

    @Override
    public int totalOperations() {
        return this.operationCounter;
    }

    @Override
    public long sizeInBytes() {
        return this.writtenOffset;
    }

    protected void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslogReader newReaderFromWriter() {
        this.ensureOpen();
        this.channelReference.incRef();
        boolean success = false;
        try {
            InnerReader reader = new InnerReader(this.generation, this.firstOperationOffset, this.channelReference);
            success = true;
            InnerReader innerReader = reader;
            return innerReader;
        }
        finally {
            if (!success) {
                this.channelReference.decRef();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public ImmutableTranslogReader immutableReader() throws TranslogException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean syncUpTo(long offset) throws IOException {
        if (this.lastSyncedOffset < offset) {
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    protected void readBytes(ByteBuffer buffer, long position) throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            org.elasticsearch.common.io.Channels.readFromFileChannelWithEofException(this.channel, position, buffer);
        }
    }

    protected synchronized void checkpoint(long lastSyncPosition, int operationCounter, ChannelReference channelReference) throws IOException {
        try {
            channelReference.getChannel().force(false);
            TranslogWriter.writeCheckpoint(lastSyncPosition, operationCounter, channelReference.getPath().getParent(), channelReference.getGeneration(), StandardOpenOption.WRITE);
        }
        catch (Throwable ex) {
            this.closeWithTragicEvent(ex);
            throw ex;
        }
    }

    private static void writeCheckpoint(long syncPosition, int numOperations, Path translogFile, long generation, OpenOption ... options) throws IOException {
        Path checkpointFile = translogFile.resolve("translog.ckp");
        Checkpoint checkpoint = new Checkpoint(syncPosition, numOperations, generation);
        Checkpoint.write(checkpointFile, checkpoint, options);
    }

    @Override
    protected final void ensureOpen() {
        if (this.isClosed()) {
            throw new AlreadyClosedException("translog [" + this.getGeneration() + "] is already closed", this.tragedy);
        }
    }

    static class ChannelFactory {
        static final ChannelFactory DEFAULT = new ChannelFactory();

        ChannelFactory() {
        }

        public FileChannel open(Path file) throws IOException {
            return FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE_NEW);
        }
    }

    final class InnerReader
    extends TranslogReader {
        public InnerReader(long generation, long fistOperationOffset, ChannelReference channelReference) {
            super(generation, channelReference, fistOperationOffset);
        }

        @Override
        public long sizeInBytes() {
            return TranslogWriter.this.sizeInBytes();
        }

        @Override
        public int totalOperations() {
            return TranslogWriter.this.totalOperations();
        }

        @Override
        protected void readBytes(ByteBuffer buffer, long position) throws IOException {
            TranslogWriter.this.readBytes(buffer, position);
        }
    }

    public static enum Type {
        SIMPLE{

            @Override
            public TranslogWriter create(ShardId shardId, long generation, ChannelReference channelReference, int bufferSize) throws IOException {
                return new TranslogWriter(shardId, generation, channelReference);
            }
        }
        ,
        BUFFERED{

            @Override
            public TranslogWriter create(ShardId shardId, long generation, ChannelReference channelReference, int bufferSize) throws IOException {
                return new BufferingTranslogWriter(shardId, generation, channelReference, bufferSize);
            }
        };


        public abstract TranslogWriter create(ShardId var1, long var2, ChannelReference var4, int var5) throws IOException;

        public static Type fromString(String type) {
            if (SIMPLE.name().equalsIgnoreCase(type)) {
                return SIMPLE;
            }
            if (BUFFERED.name().equalsIgnoreCase(type)) {
                return BUFFERED;
            }
            throw new IllegalArgumentException("No translog fs type [" + type + "]");
        }
    }
}

