/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.GeoHashUtils;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketStreamContext;
import org.elasticsearch.search.aggregations.bucket.BucketStreams;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGrid;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalGeoHashGrid
extends InternalMultiBucketAggregation<InternalGeoHashGrid, Bucket>
implements GeoHashGrid {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("geohash_grid", "ghcells");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalGeoHashGrid readResult(StreamInput in) throws IOException {
            InternalGeoHashGrid buckets = new InternalGeoHashGrid();
            buckets.readFrom(in);
            return buckets;
        }
    };
    public static final BucketStreams.Stream<Bucket> BUCKET_STREAM = new BucketStreams.Stream<Bucket>(){

        @Override
        public Bucket readResult(StreamInput in, BucketStreamContext context) throws IOException {
            Bucket bucket = new Bucket();
            bucket.readFrom(in);
            return bucket;
        }

        @Override
        public BucketStreamContext getBucketStreamContext(Bucket bucket) {
            BucketStreamContext context = new BucketStreamContext();
            return context;
        }
    };
    private int requiredSize;
    private Collection<Bucket> buckets;
    protected Map<String, Bucket> bucketMap;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
        BucketStreams.registerStream(BUCKET_STREAM, TYPE.stream());
    }

    InternalGeoHashGrid() {
    }

    public InternalGeoHashGrid(String name, int requiredSize, Collection<Bucket> buckets, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.requiredSize = requiredSize;
        this.buckets = buckets;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalGeoHashGrid create(List<Bucket> buckets) {
        return new InternalGeoHashGrid(this.name, this.requiredSize, buckets, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.geohashAsLong, prototype.docCount, aggregations);
    }

    @Override
    public List<GeoHashGrid.Bucket> getBuckets() {
        Collection<Bucket> o = this.buckets;
        return (List)o;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalGeoHashGrid doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var7_12;
        LongObjectPagedHashMap<ArrayList<Bucket>> buckets = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoHashGrid grid = (InternalGeoHashGrid)aggregation;
            if (buckets == null) {
                buckets = new LongObjectPagedHashMap<ArrayList<Bucket>>(grid.buckets.size(), reduceContext.bigArrays());
            }
            for (Bucket bucket : grid.buckets) {
                ArrayList<Bucket> existingBuckets = (ArrayList<Bucket>)buckets.get(bucket.geohashAsLong);
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<Bucket>(aggregations.size());
                    buckets.put(bucket.geohashAsLong, existingBuckets);
                }
                existingBuckets.add(bucket);
            }
        }
        int size = (int)Math.min((long)this.requiredSize, buckets.size());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size);
        for (LongObjectPagedHashMap.Cursor cursor : buckets) {
            List sameCellBuckets = (List)cursor.value;
            ordered.insertWithOverflow(((Bucket)sameCellBuckets.get(0)).reduce(sameCellBuckets, reduceContext));
        }
        buckets.close();
        Bucket[] list = new Bucket[ordered.size()];
        int n = ordered.size() - 1;
        while (var7_12 >= 0) {
            list[var7_12] = (Bucket)ordered.pop();
            --var7_12;
        }
        return new InternalGeoHashGrid(this.getName(), this.requiredSize, Arrays.asList(list), this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.requiredSize = InternalGeoHashGrid.readSize(in);
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            Bucket bucket = new Bucket();
            bucket.readFrom(in);
            buckets.add(bucket);
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalGeoHashGrid.writeSize(this.requiredSize, out);
        out.writeVInt(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    static class BucketPriorityQueue
    extends PriorityQueue<Bucket> {
        public BucketPriorityQueue(int size) {
            super(size);
        }

        @Override
        protected boolean lessThan(Bucket o1, Bucket o2) {
            long i = o2.getDocCount() - o1.getDocCount();
            if (i == 0L && (i = (long)o2.compareTo(o1)) == 0L) {
                i = System.identityHashCode(o2) - System.identityHashCode(o1);
            }
            return i > 0L;
        }
    }

    static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements GeoHashGrid.Bucket,
    Comparable<Bucket> {
        protected long geohashAsLong;
        protected long docCount;
        protected InternalAggregations aggregations;

        public Bucket() {
        }

        public Bucket(long geohashAsLong, long docCount, InternalAggregations aggregations) {
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.geohashAsLong = geohashAsLong;
        }

        @Override
        public String getKeyAsString() {
            return GeoHashUtils.stringEncode(this.geohashAsLong);
        }

        @Override
        public GeoPoint getKey() {
            return GeoPoint.fromGeohash(this.geohashAsLong);
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public int compareTo(Bucket other) {
            if (this.geohashAsLong > other.geohashAsLong) {
                return 1;
            }
            if (this.geohashAsLong < other.geohashAsLong) {
                return -1;
            }
            return 0;
        }

        public Bucket reduce(List<? extends Bucket> buckets, InternalAggregation.ReduceContext context) {
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            long docCount = 0L;
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                aggregationsList.add(bucket.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
            return new Bucket(this.geohashAsLong, docCount, aggs);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.geohashAsLong = in.readLong();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.geohashAsLong);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, this.getKeyAsString());
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

