/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class InternalDateHistogram {
    static final InternalAggregation.Type TYPE = new InternalAggregation.Type("date_histogram", "dhisto");

    private InternalDateHistogram() {
    }

    static class Factory
    extends InternalHistogram.Factory<Bucket> {
        Factory() {
        }

        @Override
        public String type() {
            return TYPE.name();
        }

        @Override
        public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
            return new Bucket(prototype.key, prototype.docCount, aggregations, prototype.getKeyed(), prototype.formatter, this);
        }

        @Override
        public Bucket createBucket(Object key, long docCount, InternalAggregations aggregations, boolean keyed, ValueFormatter formatter) {
            if (key instanceof Number) {
                return new Bucket(((Number)key).longValue(), docCount, aggregations, keyed, formatter, this);
            }
            if (key instanceof DateTime) {
                return new Bucket(((DateTime)key).getMillis(), docCount, aggregations, keyed, formatter, this);
            }
            throw new AggregationExecutionException("Expected key of type Number or DateTime but got [" + key + "]");
        }

        @Override
        protected Bucket createEmptyBucket(boolean keyed, ValueFormatter formatter) {
            return new Bucket(keyed, formatter, this);
        }
    }

    static class Bucket
    extends InternalHistogram.Bucket {
        Bucket(boolean keyed, ValueFormatter formatter, InternalHistogram.Factory<Bucket> factory) {
            super(keyed, formatter, factory);
        }

        Bucket(long key, long docCount, InternalAggregations aggregations, boolean keyed, ValueFormatter formatter, InternalHistogram.Factory<Bucket> factory) {
            super(key, docCount, keyed, formatter, factory, aggregations);
        }

        @Override
        public String getKeyAsString() {
            return this.formatter != null ? this.formatter.format(this.key) : ValueFormatter.DateTime.DEFAULT.format(this.key);
        }

        @Override
        public DateTime getKey() {
            return new DateTime(this.key, DateTimeZone.UTC);
        }

        public String toString() {
            return this.getKeyAsString();
        }
    }
}

