/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms.support;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class IncludeExclude {
    private final RegExp include;
    private final RegExp exclude;
    private final SortedSet<BytesRef> includeValues;
    private final SortedSet<BytesRef> excludeValues;

    public IncludeExclude(RegExp include, RegExp exclude) {
        if (include == null && exclude == null) {
            throw new IllegalArgumentException();
        }
        this.include = include;
        this.exclude = exclude;
        this.includeValues = null;
        this.excludeValues = null;
    }

    public IncludeExclude(SortedSet<BytesRef> includeValues, SortedSet<BytesRef> excludeValues) {
        if (includeValues == null && excludeValues == null) {
            throw new IllegalArgumentException();
        }
        this.include = null;
        this.exclude = null;
        this.includeValues = includeValues;
        this.excludeValues = excludeValues;
    }

    public boolean isRegexBased() {
        return this.include != null || this.exclude != null;
    }

    private Automaton toAutomaton() {
        Automaton a = null;
        a = this.include != null ? this.include.toAutomaton() : (this.includeValues != null ? Automata.makeStringUnion(this.includeValues) : Automata.makeAnyString());
        if (this.exclude != null) {
            a = Operations.minus(a, this.exclude.toAutomaton(), 10000);
        } else if (this.excludeValues != null) {
            a = Operations.minus(a, Automata.makeStringUnion(this.excludeValues), 10000);
        }
        return a;
    }

    public StringFilter convertToStringFilter() {
        if (this.isRegexBased()) {
            return new AutomatonBackedStringFilter(this.toAutomaton());
        }
        return new TermListBackedStringFilter(this.includeValues, this.excludeValues);
    }

    public OrdinalsFilter convertToOrdinalsFilter() {
        if (this.isRegexBased()) {
            return new AutomatonBackedOrdinalsFilter(this.toAutomaton());
        }
        return new TermListBackedOrdinalsFilter(this.includeValues, this.excludeValues);
    }

    public LongFilter convertToLongFilter() {
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        LongFilter result = new LongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                result.addAccept(Long.parseLong(val.utf8ToString()));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                result.addReject(Long.parseLong(val.utf8ToString()));
            }
        }
        return result;
    }

    public LongFilter convertToDoubleFilter() {
        double dval;
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        LongFilter result = new LongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addAccept(NumericUtils.doubleToSortableLong(dval));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addReject(NumericUtils.doubleToSortableLong(dval));
            }
        }
        return result;
    }

    public static class Parser {
        String include = null;
        String exclude = null;
        SortedSet<BytesRef> includeValues;
        SortedSet<BytesRef> excludeValues;

        public boolean token(String currentFieldName, XContentParser.Token token, XContentParser parser) throws IOException {
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("include".equals(currentFieldName)) {
                    this.include = parser.text();
                } else if ("exclude".equals(currentFieldName)) {
                    this.exclude = parser.text();
                } else {
                    return false;
                }
                return true;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("include".equals(currentFieldName)) {
                    this.includeValues = new TreeSet<BytesRef>(this.parseArrayToSet(parser));
                    return true;
                }
                if ("exclude".equals(currentFieldName)) {
                    this.excludeValues = new TreeSet<BytesRef>(this.parseArrayToSet(parser));
                    return true;
                }
                return false;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("include".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_STRING || !"pattern".equals(currentFieldName)) continue;
                        this.include = parser.text();
                    }
                } else if ("exclude".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_STRING || !"pattern".equals(currentFieldName)) continue;
                        this.exclude = parser.text();
                    }
                } else {
                    return false;
                }
                return true;
            }
            return false;
        }

        private Set<BytesRef> parseArrayToSet(XContentParser parser) throws IOException {
            HashSet<BytesRef> set = new HashSet<BytesRef>();
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("Missing start of array in include/exclude clause", new Object[0]);
            }
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (!parser.currentToken().isValue()) {
                    throw new ElasticsearchParseException("Array elements in include/exclude clauses should be string values", new Object[0]);
                }
                set.add(new BytesRef(parser.text()));
            }
            return set;
        }

        public IncludeExclude includeExclude() {
            RegExp excludePattern;
            RegExp includePattern = this.include != null ? new RegExp(this.include) : null;
            RegExp regExp = excludePattern = this.exclude != null ? new RegExp(this.exclude) : null;
            if (includePattern != null || excludePattern != null) {
                if (this.includeValues != null || this.excludeValues != null) {
                    throw new IllegalArgumentException("Can only use regular expression include/exclude or a set of values, not both");
                }
                return new IncludeExclude(includePattern, excludePattern);
            }
            if (this.includeValues != null || this.excludeValues != null) {
                return new IncludeExclude(this.includeValues, this.excludeValues);
            }
            return null;
        }
    }

    private static class DocValuesTerms
    extends Terms {
        private final SortedSetDocValues values;

        DocValuesTerms(SortedSetDocValues values) {
            this.values = values;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return this.values.termsEnum();
        }

        @Override
        public long size() throws IOException {
            return -1L;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return -1L;
        }

        @Override
        public int getDocCount() throws IOException {
            return -1;
        }

        @Override
        public boolean hasFreqs() {
            return false;
        }

        @Override
        public boolean hasOffsets() {
            return false;
        }

        @Override
        public boolean hasPositions() {
            return false;
        }

        @Override
        public boolean hasPayloads() {
            return false;
        }
    }

    static class TermListBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final SortedSet<BytesRef> includeValues;
        private final SortedSet<BytesRef> excludeValues;

        public TermListBackedOrdinalsFilter(SortedSet<BytesRef> includeValues, SortedSet<BytesRef> excludeValues) {
            this.includeValues = includeValues;
            this.excludeValues = excludeValues;
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(RandomAccessOrds globalOrdinals, ValuesSource.Bytes.WithOrdinals valueSource) throws IOException {
            long ord;
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
            if (this.includeValues != null) {
                for (BytesRef term : this.includeValues) {
                    ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.set(ord);
                }
            } else {
                acceptedGlobalOrdinals.set(0L, acceptedGlobalOrdinals.length());
            }
            if (this.excludeValues != null) {
                for (BytesRef term : this.excludeValues) {
                    ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.clear(ord);
                }
            }
            return acceptedGlobalOrdinals;
        }
    }

    static class AutomatonBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final CompiledAutomaton compiled;

        private AutomatonBackedOrdinalsFilter(Automaton automaton) {
            this.compiled = new CompiledAutomaton(automaton);
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(RandomAccessOrds globalOrdinals, ValuesSource.Bytes.WithOrdinals valueSource) throws IOException {
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
            DocValuesTerms globalTerms = new DocValuesTerms(globalOrdinals);
            TermsEnum globalTermsEnum = this.compiled.getTermsEnum(globalTerms);
            BytesRef term = globalTermsEnum.next();
            while (term != null) {
                acceptedGlobalOrdinals.set(globalTermsEnum.ord());
                term = globalTermsEnum.next();
            }
            return acceptedGlobalOrdinals;
        }
    }

    public static abstract class OrdinalsFilter {
        public abstract LongBitSet acceptedGlobalOrdinals(RandomAccessOrds var1, ValuesSource.Bytes.WithOrdinals var2) throws IOException;
    }

    static class TermListBackedStringFilter
    extends StringFilter {
        private final Set<BytesRef> valids;
        private final Set<BytesRef> invalids;

        public TermListBackedStringFilter(Set<BytesRef> includeValues, Set<BytesRef> excludeValues) {
            this.valids = includeValues;
            this.invalids = excludeValues;
        }

        @Override
        public boolean accept(BytesRef value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }
    }

    static class AutomatonBackedStringFilter
    extends StringFilter {
        private final ByteRunAutomaton runAutomaton;

        private AutomatonBackedStringFilter(Automaton automaton) {
            this.runAutomaton = new ByteRunAutomaton(automaton);
        }

        @Override
        public boolean accept(BytesRef value) {
            return this.runAutomaton.run(value.bytes, value.offset, value.length);
        }
    }

    public static abstract class StringFilter {
        public abstract boolean accept(BytesRef var1);
    }

    public static class LongFilter {
        private LongSet valids;
        private LongSet invalids;

        private LongFilter(int numValids, int numInvalids) {
            if (numValids > 0) {
                this.valids = new LongHashSet(numValids);
            }
            if (numInvalids > 0) {
                this.invalids = new LongHashSet(numInvalids);
            }
        }

        public boolean accept(long value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }

        private void addAccept(long val) {
            this.valids.add(val);
        }

        private void addReject(long val) {
            this.invalids.add(val);
        }
    }
}

