/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.geocentroid;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.GeoUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.geocentroid.GeoCentroid;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalGeoCentroid
extends InternalMetricsAggregation
implements GeoCentroid {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("geo_centroid");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalGeoCentroid readResult(StreamInput in) throws IOException {
            InternalGeoCentroid result = new InternalGeoCentroid();
            result.readFrom(in);
            return result;
        }
    };
    protected GeoPoint centroid;
    protected long count;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    protected InternalGeoCentroid() {
    }

    public InternalGeoCentroid(String name, GeoPoint centroid, long count, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.centroid = centroid;
        assert (count >= 0L);
        this.count = count;
    }

    @Override
    public GeoPoint centroid() {
        return this.centroid == null || Double.isNaN(this.centroid.lon()) ? null : this.centroid;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalGeoCentroid doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double lonSum = Double.NaN;
        double latSum = Double.NaN;
        int totalCount = 0;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoCentroid centroidAgg = (InternalGeoCentroid)aggregation;
            if (centroidAgg.count <= 0L) continue;
            totalCount = (int)((long)totalCount + centroidAgg.count);
            if (Double.isNaN(lonSum)) {
                lonSum = (double)centroidAgg.count * centroidAgg.centroid.getLon();
                latSum = (double)centroidAgg.count * centroidAgg.centroid.getLat();
                continue;
            }
            lonSum += (double)centroidAgg.count * centroidAgg.centroid.getLon();
            latSum += (double)centroidAgg.count * centroidAgg.centroid.getLat();
        }
        GeoPoint result = Double.isNaN(lonSum) ? null : new GeoPoint(latSum / (double)totalCount, lonSum / (double)totalCount);
        return new InternalGeoCentroid(this.name, result, totalCount, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String coordinate;
            switch (coordinate = path.get(0)) {
                case "value": {
                    return this.centroid;
                }
                case "lat": {
                    return this.centroid.lat();
                }
                case "lon": {
                    return this.centroid.lon();
                }
            }
            throw new IllegalArgumentException("Found unknown path element [" + coordinate + "] in [" + this.getName() + "]");
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.centroid = in.readBoolean() ? GeoPoint.fromIndexLong(in.readLong()) : null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        if (this.centroid != null) {
            out.writeBoolean(true);
            out.writeLong(GeoUtils.mortonHash(this.centroid.lon(), this.centroid.lat()));
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.centroid != null) {
            builder.startObject(Fields.CENTROID).field("lat", this.centroid.lat()).field("lon", this.centroid.lon()).endObject();
        }
        return builder;
    }

    static class Fields {
        public static final XContentBuilderString CENTROID = new XContentBuilderString("location");

        Fields() {
        }
    }
}

