/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.innerhits;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.FilteredSearchContext;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public final class InnerHitsContext {
    private final Map<String, BaseInnerHits> innerHits;

    public InnerHitsContext(Map<String, BaseInnerHits> innerHits) {
        this.innerHits = innerHits;
    }

    public Map<String, BaseInnerHits> getInnerHits() {
        return this.innerHits;
    }

    public void addInnerHitDefinition(String name, BaseInnerHits innerHit) {
        this.innerHits.put(name, innerHit);
    }

    public static final class ParentChildInnerHits
    extends BaseInnerHits {
        private final MapperService mapperService;
        private final DocumentMapper documentMapper;

        public ParentChildInnerHits(SearchContext context, ParsedQuery query, Map<String, BaseInnerHits> childInnerHits, MapperService mapperService, DocumentMapper documentMapper) {
            super(context, query, childInnerHits);
            this.mapperService = mapperService;
            this.documentMapper = documentMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopDocs topDocs(SearchContext context, FetchSubPhase.HitContext hitContext) throws IOException {
            String term;
            String field;
            if (this.isParentHit(hitContext.hit())) {
                field = "_parent";
                term = Uid.createUid(hitContext.hit().type(), hitContext.hit().id());
            } else if (this.isChildHit(hitContext.hit())) {
                DocumentMapper hitDocumentMapper = this.mapperService.documentMapper(hitContext.hit().type());
                String parentType = hitDocumentMapper.parentFieldMapper().type();
                field = "_uid";
                SearchHitField parentField = hitContext.hit().field("_parent");
                if (parentField == null) {
                    throw new IllegalStateException("All children must have a _parent");
                }
                term = Uid.createUid(parentType, (String)parentField.getValue());
            } else {
                return Lucene.EMPTY_TOP_DOCS;
            }
            BooleanQuery q = new BooleanQuery.Builder().add(this.query.query(), BooleanClause.Occur.MUST).add(new TermQuery(new Term(field, term)), BooleanClause.Occur.MUST).add(this.documentMapper.typeFilter(), BooleanClause.Occur.MUST).build();
            if (this.size() == 0) {
                int count = context.searcher().count(q);
                return new TopDocs(count, Lucene.EMPTY_SCORE_DOCS, 0.0f);
            }
            int topN = Math.min(this.from() + this.size(), context.searcher().getIndexReader().maxDoc());
            TopDocsCollector topDocsCollector = this.sort() != null ? TopFieldCollector.create(this.sort(), topN, true, this.trackScores(), this.trackScores()) : TopScoreDocCollector.create(topN);
            try {
                context.searcher().search((Query)q, topDocsCollector);
            }
            finally {
                this.clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
            return topDocsCollector.topDocs(this.from(), this.size());
        }

        private boolean isParentHit(InternalSearchHit hit) {
            return hit.type().equals(this.documentMapper.parentFieldMapper().type());
        }

        private boolean isChildHit(InternalSearchHit hit) {
            DocumentMapper hitDocumentMapper = this.mapperService.documentMapper(hit.type());
            return this.documentMapper.type().equals(hitDocumentMapper.parentFieldMapper().type());
        }
    }

    public static final class NestedInnerHits
    extends BaseInnerHits {
        private final ObjectMapper parentObjectMapper;
        private final ObjectMapper childObjectMapper;

        public NestedInnerHits(SearchContext context, ParsedQuery query, Map<String, BaseInnerHits> childInnerHits, ObjectMapper parentObjectMapper, ObjectMapper childObjectMapper) {
            super(context, query, childInnerHits);
            this.parentObjectMapper = parentObjectMapper;
            this.childObjectMapper = childObjectMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopDocs topDocs(SearchContext context, FetchSubPhase.HitContext hitContext) throws IOException {
            TopDocsCollector topDocsCollector;
            Query rawParentFilter = this.parentObjectMapper == null ? Queries.newNonNestedFilter() : this.parentObjectMapper.nestedTypeFilter();
            BitSetProducer parentFilter = context.bitsetFilterCache().getBitSetProducer(rawParentFilter);
            Query childFilter = this.childObjectMapper.nestedTypeFilter();
            BooleanQuery q = Queries.filtered(this.query.query(), new NestedChildrenQuery(parentFilter, childFilter, hitContext));
            if (this.size() == 0) {
                return new TopDocs(context.searcher().count(q), Lucene.EMPTY_SCORE_DOCS, 0.0f);
            }
            int topN = Math.min(this.from() + this.size(), context.searcher().getIndexReader().maxDoc());
            if (this.sort() != null) {
                try {
                    topDocsCollector = TopFieldCollector.create(this.sort(), topN, true, this.trackScores(), this.trackScores());
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToElastic(e);
                }
            } else {
                topDocsCollector = TopScoreDocCollector.create(topN);
            }
            try {
                context.searcher().search((Query)q, topDocsCollector);
            }
            finally {
                this.clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
            return topDocsCollector.topDocs(this.from(), this.size());
        }

        static class NestedChildrenQuery
        extends Query {
            private final BitSetProducer parentFilter;
            private final Query childFilter;
            private final int docId;
            private final LeafReader leafReader;

            NestedChildrenQuery(BitSetProducer parentFilter, Query childFilter, FetchSubPhase.HitContext hitContext) {
                this.parentFilter = parentFilter;
                this.childFilter = childFilter;
                this.docId = hitContext.docId();
                this.leafReader = hitContext.readerContext().reader();
            }

            @Override
            public boolean equals(Object obj) {
                if (!super.equals(obj)) {
                    return false;
                }
                NestedChildrenQuery other = (NestedChildrenQuery)obj;
                return this.parentFilter.equals(other.parentFilter) && this.childFilter.equals(other.childFilter) && this.docId == other.docId && this.leafReader.getCoreCacheKey() == other.leafReader.getCoreCacheKey();
            }

            @Override
            public int hashCode() {
                int hash = super.hashCode();
                hash = 31 * hash + this.parentFilter.hashCode();
                hash = 31 * hash + this.childFilter.hashCode();
                hash = 31 * hash + this.docId;
                hash = 31 * hash + this.leafReader.getCoreCacheKey().hashCode();
                return hash;
            }

            @Override
            public String toString(String field) {
                return "NestedChildren(parent=" + this.parentFilter + ",child=" + this.childFilter + ")";
            }

            @Override
            public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
                final Weight childWeight = this.childFilter.createWeight(searcher, false);
                return new ConstantScoreWeight(this){

                    @Override
                    public Scorer scorer(LeafReaderContext context) throws IOException {
                        if (!context.reader().getCoreCacheKey().equals(NestedChildrenQuery.this.leafReader.getCoreCacheKey())) {
                            return null;
                        }
                        if (NestedChildrenQuery.this.docId == 0) {
                            return null;
                        }
                        BitSet parents = NestedChildrenQuery.this.parentFilter.getBitSet(context);
                        final int firstChildDocId = parents.prevSetBit(NestedChildrenQuery.this.docId - 1) + 1;
                        if (firstChildDocId == NestedChildrenQuery.this.docId) {
                            return null;
                        }
                        final Scorer childrenIterator = childWeight.scorer(context);
                        if (childrenIterator == null) {
                            return null;
                        }
                        DocIdSetIterator it = new DocIdSetIterator(){
                            int doc = -1;

                            @Override
                            public int docID() {
                                return this.doc;
                            }

                            @Override
                            public int nextDoc() throws IOException {
                                return this.advance(this.doc + 1);
                            }

                            @Override
                            public int advance(int target) throws IOException {
                                if ((target = Math.max(firstChildDocId, target)) >= NestedChildrenQuery.this.docId) {
                                    this.doc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                int advanced = childrenIterator.advance(target);
                                if (advanced >= NestedChildrenQuery.this.docId) {
                                    this.doc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                this.doc = advanced;
                                return this.doc;
                            }

                            @Override
                            public long cost() {
                                return Math.min(childrenIterator.cost(), (long)(NestedChildrenQuery.this.docId - firstChildDocId));
                            }
                        };
                        return new ConstantScoreScorer((Weight)this, this.score(), it);
                    }
                };
            }
        }
    }

    public static abstract class BaseInnerHits
    extends FilteredSearchContext {
        protected final ParsedQuery query;
        private final InnerHitsContext childInnerHits;

        protected BaseInnerHits(SearchContext context, ParsedQuery query, Map<String, BaseInnerHits> childInnerHits) {
            super(context);
            this.query = query;
            this.childInnerHits = childInnerHits != null && !childInnerHits.isEmpty() ? new InnerHitsContext(childInnerHits) : null;
        }

        @Override
        public Query query() {
            return this.query.query();
        }

        @Override
        public ParsedQuery parsedQuery() {
            return this.query;
        }

        public abstract TopDocs topDocs(SearchContext var1, FetchSubPhase.HitContext var2) throws IOException;

        @Override
        public InnerHitsContext innerHits() {
            return this.childInnerHits;
        }
    }
}

