/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.profile.ProfileBreakdown;
import org.elasticsearch.search.profile.ProfileWeight;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private ProfileWeight profileWeight;
    private final ProfileBreakdown profile;

    ProfileScorer(ProfileWeight w, Scorer scorer, ProfileBreakdown profile) throws IOException {
        super(w);
        this.scorer = scorer;
        this.profileWeight = w;
        this.profile = profile;
    }

    @Override
    public int docID() {
        return this.scorer.docID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int advance(int target) throws IOException {
        this.profile.startTime(ProfileBreakdown.TimingType.ADVANCE);
        try {
            int n = this.scorer.advance(target);
            return n;
        }
        finally {
            this.profile.stopAndRecordTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextDoc() throws IOException {
        this.profile.startTime(ProfileBreakdown.TimingType.NEXT_DOC);
        try {
            int n = this.scorer.nextDoc();
            return n;
        }
        finally {
            this.profile.stopAndRecordTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float score() throws IOException {
        this.profile.startTime(ProfileBreakdown.TimingType.SCORE);
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.profile.stopAndRecordTime();
        }
    }

    @Override
    public int freq() throws IOException {
        return this.scorer.freq();
    }

    @Override
    public long cost() {
        return this.scorer.cost();
    }

    @Override
    public Weight getWeight() {
        return this.profileWeight;
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        return this.scorer.getChildren();
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.asTwoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        DocIdSetIterator approximation = new DocIdSetIterator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int advance(int target) throws IOException {
                ProfileScorer.this.profile.startTime(ProfileBreakdown.TimingType.ADVANCE);
                try {
                    int n = inApproximation.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int nextDoc() throws IOException {
                ProfileScorer.this.profile.startTime(ProfileBreakdown.TimingType.NEXT_DOC);
                try {
                    int n = inApproximation.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            @Override
            public int docID() {
                return inApproximation.docID();
            }

            @Override
            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(approximation){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean matches() throws IOException {
                ProfileScorer.this.profile.startTime(ProfileBreakdown.TimingType.MATCH);
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            @Override
            public float matchCost() {
                return in.matchCost();
            }
        };
    }
}

