/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;

public final class QueryRescorer
implements Rescorer {
    public static final Rescorer INSTANCE = new QueryRescorer();
    public static final String NAME = "query";
    private static final Comparator<ScoreDoc> SCORE_DOC_COMPARATOR = new Comparator<ScoreDoc>(){

        @Override
        public int compare(ScoreDoc o1, ScoreDoc o2) {
            int cmp = Float.compare(o2.score, o1.score);
            return cmp == 0 ? Integer.compare(o1.doc, o2.doc) : cmp;
        }
    };

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public TopDocs rescore(TopDocs topDocs, SearchContext context, RescoreSearchContext rescoreContext) throws IOException {
        assert (rescoreContext != null);
        if (topDocs == null || topDocs.totalHits == 0 || topDocs.scoreDocs.length == 0) {
            return topDocs;
        }
        final QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        org.apache.lucene.search.QueryRescorer rescorer = new org.apache.lucene.search.QueryRescorer(rescore.query()){

            @Override
            protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                if (secondPassMatches) {
                    return rescore.scoreMode.combine(firstPassScore * rescore.queryWeight(), secondPassScore * rescore.rescoreQueryWeight());
                }
                return firstPassScore * rescore.queryWeight();
            }
        };
        TopDocs topNFirstPass = this.topN(topDocs, rescoreContext.window());
        TopDocs rescored = ((org.apache.lucene.search.Rescorer)rescorer).rescore(context.searcher(), topNFirstPass, rescoreContext.window());
        return this.combine(topDocs, rescored, (QueryRescoreContext)rescoreContext);
    }

    @Override
    public Explanation explain(int topLevelDocId, SearchContext context, RescoreSearchContext rescoreContext, Explanation sourceExplanation) throws IOException {
        QueryRescoreContext rescore = (QueryRescoreContext)rescoreContext;
        ContextIndexSearcher searcher = context.searcher();
        if (sourceExplanation == null) {
            return Explanation.noMatch("nothing matched", new Explanation[0]);
        }
        Explanation rescoreExplain = searcher.explain(rescore.query(), topLevelDocId);
        float primaryWeight = rescore.queryWeight();
        Explanation prim = sourceExplanation.isMatch() ? Explanation.match(sourceExplanation.getValue() * primaryWeight, "product of:", sourceExplanation, Explanation.match(primaryWeight, "primaryWeight", new Explanation[0])) : Explanation.noMatch("First pass did not match", sourceExplanation);
        if (rescoreExplain != null && rescoreExplain.isMatch()) {
            float secondaryWeight = rescore.rescoreQueryWeight();
            Explanation sec = Explanation.match(rescoreExplain.getValue() * secondaryWeight, "product of:", rescoreExplain, Explanation.match(secondaryWeight, "secondaryWeight", new Explanation[0]));
            ScoreMode scoreMode = rescore.scoreMode();
            return Explanation.match(scoreMode.combine(prim.getValue(), sec.getValue()), (Object)((Object)scoreMode) + " of:", prim, sec);
        }
        return prim;
    }

    @Override
    public RescoreSearchContext parse(XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        QueryRescoreContext rescoreContext = new QueryRescoreContext(this);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                if (!"rescore_query".equals(fieldName)) continue;
                ParsedQuery parsedQuery = context.queryParserService().parse(parser);
                rescoreContext.setParsedQuery(parsedQuery);
                continue;
            }
            if (!token.isValue()) continue;
            if ("query_weight".equals(fieldName)) {
                rescoreContext.setQueryWeight(parser.floatValue());
                continue;
            }
            if ("rescore_query_weight".equals(fieldName)) {
                rescoreContext.setRescoreQueryWeight(parser.floatValue());
                continue;
            }
            if ("score_mode".equals(fieldName)) {
                String sScoreMode = parser.text();
                if ("avg".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Avg);
                    continue;
                }
                if ("max".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Max);
                    continue;
                }
                if ("min".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Min);
                    continue;
                }
                if ("total".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Total);
                    continue;
                }
                if ("multiply".equals(sScoreMode)) {
                    rescoreContext.setScoreMode(ScoreMode.Multiply);
                    continue;
                }
                throw new IllegalArgumentException("[rescore] illegal score_mode [" + sScoreMode + "]");
            }
            throw new IllegalArgumentException("rescore doesn't support [" + fieldName + "]");
        }
        return rescoreContext;
    }

    private TopDocs topN(TopDocs in, int topN) {
        if (in.totalHits < topN) {
            assert (in.scoreDocs.length == in.totalHits);
            return in;
        }
        ScoreDoc[] subset = new ScoreDoc[topN];
        System.arraycopy(in.scoreDocs, 0, subset, 0, topN);
        return new TopDocs(in.totalHits, subset, in.getMaxScore());
    }

    private TopDocs combine(TopDocs in, TopDocs resorted, QueryRescoreContext ctx) {
        System.arraycopy(resorted.scoreDocs, 0, in.scoreDocs, 0, resorted.scoreDocs.length);
        if (in.scoreDocs.length > resorted.scoreDocs.length) {
            for (int i = resorted.scoreDocs.length; i < in.scoreDocs.length; ++i) {
                in.scoreDocs[i].score *= ctx.queryWeight();
            }
            Arrays.sort(in.scoreDocs, SCORE_DOC_COMPARATOR);
        }
        return in;
    }

    @Override
    public void extractTerms(SearchContext context, RescoreSearchContext rescoreContext, Set<Term> termsSet) {
        try {
            context.searcher().createNormalizedWeight(((QueryRescoreContext)rescoreContext).query(), false).extractTerms(termsSet);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to extract terms", e);
        }
    }

    public static class QueryRescoreContext
    extends RescoreSearchContext {
        private ParsedQuery parsedQuery;
        private float queryWeight = 1.0f;
        private float rescoreQueryWeight = 1.0f;
        private ScoreMode scoreMode = ScoreMode.Total;

        public QueryRescoreContext(QueryRescorer rescorer) {
            super(QueryRescorer.NAME, 10, rescorer);
        }

        public void setParsedQuery(ParsedQuery parsedQuery) {
            this.parsedQuery = parsedQuery;
        }

        public Query query() {
            return this.parsedQuery.query();
        }

        public float queryWeight() {
            return this.queryWeight;
        }

        public float rescoreQueryWeight() {
            return this.rescoreQueryWeight;
        }

        public ScoreMode scoreMode() {
            return this.scoreMode;
        }

        public void setRescoreQueryWeight(float rescoreQueryWeight) {
            this.rescoreQueryWeight = rescoreQueryWeight;
        }

        public void setQueryWeight(float queryWeight) {
            this.queryWeight = queryWeight;
        }

        public void setScoreMode(ScoreMode scoreMode) {
            this.scoreMode = scoreMode;
        }
    }

    private static enum ScoreMode {
        Avg{

            @Override
            public float combine(float primary, float secondary) {
                return (primary + secondary) / 2.0f;
            }

            public String toString() {
                return "avg";
            }
        }
        ,
        Max{

            @Override
            public float combine(float primary, float secondary) {
                return Math.max(primary, secondary);
            }

            public String toString() {
                return "max";
            }
        }
        ,
        Min{

            @Override
            public float combine(float primary, float secondary) {
                return Math.min(primary, secondary);
            }

            public String toString() {
                return "min";
            }
        }
        ,
        Total{

            @Override
            public float combine(float primary, float secondary) {
                return primary + secondary;
            }

            public String toString() {
                return "sum";
            }
        }
        ,
        Multiply{

            @Override
            public float combine(float primary, float secondary) {
                return primary * secondary;
            }

            public String toString() {
                return "product";
            }
        };


        public abstract float combine(float var1, float var2);
    }
}

