/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class MatrixAggregation
extends AggregationBase {
    private final List<String> fields;
    private final Map<String, Double> missing;

    protected MatrixAggregation(AbstractBuilder<?> builder) {
        super(builder);
        this.fields = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
        this.missing = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).missing);
    }

    public final List<String> fields() {
        return this.fields;
    }

    public final Map<String, Double> missing() {
        return this.missing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.missing)) {
            generator.writeKey("missing");
            generator.writeStartObject();
            for (Map.Entry entry : this.missing.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((Double)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMatrixAggregationDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(AbstractBuilder::missing, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "missing");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private List<String> fields;
        @Nullable
        private Map<String, Double> missing;

        protected AbstractBuilder() {
        }

        public final BuilderT fields(List<String> list) {
            this.fields = AbstractBuilder._listAddAll(this.fields, list);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT fields(String value, String ... values) {
            this.fields = AbstractBuilder._listAdd(this.fields, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT missing(Map<String, Double> map) {
            this.missing = AbstractBuilder._mapPutAll(this.missing, map);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT missing(String key, Double value) {
            this.missing = AbstractBuilder._mapPut(this.missing, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

