/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.OnScriptError;
import co.elastic.clients.elasticsearch._types.mapping.TimeSeriesMetricType;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class NumberPropertyBase
extends DocValuesPropertyBase {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean index;
    @Nullable
    private final OnScriptError onScriptError;
    @Nullable
    private final Script script;
    @Nullable
    private final TimeSeriesMetricType timeSeriesMetric;
    @Nullable
    private final Boolean timeSeriesDimension;

    protected NumberPropertyBase(AbstractBuilder<?> builder) {
        super((DocValuesPropertyBase.AbstractBuilder<?>)builder);
        this.boost = ((AbstractBuilder)builder).boost;
        this.coerce = ((AbstractBuilder)builder).coerce;
        this.ignoreMalformed = ((AbstractBuilder)builder).ignoreMalformed;
        this.index = ((AbstractBuilder)builder).index;
        this.onScriptError = ((AbstractBuilder)builder).onScriptError;
        this.script = ((AbstractBuilder)builder).script;
        this.timeSeriesMetric = ((AbstractBuilder)builder).timeSeriesMetric;
        this.timeSeriesDimension = ((AbstractBuilder)builder).timeSeriesDimension;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final OnScriptError onScriptError() {
        return this.onScriptError;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final TimeSeriesMetricType timeSeriesMetric() {
        return this.timeSeriesMetric;
    }

    @Nullable
    public final Boolean timeSeriesDimension() {
        return this.timeSeriesDimension;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost);
        }
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce);
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.onScriptError != null) {
            generator.writeKey("on_script_error");
            this.onScriptError.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.timeSeriesMetric != null) {
            generator.writeKey("time_series_metric");
            this.timeSeriesMetric.serialize(generator, mapper);
        }
        if (this.timeSeriesDimension != null) {
            generator.writeKey("time_series_dimension");
            generator.write(this.timeSeriesDimension);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupNumberPropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(AbstractBuilder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(AbstractBuilder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce");
        op.add(AbstractBuilder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(AbstractBuilder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(AbstractBuilder::onScriptError, OnScriptError._DESERIALIZER, "on_script_error");
        op.add(AbstractBuilder::script, Script._DESERIALIZER, "script");
        op.add(AbstractBuilder::timeSeriesMetric, TimeSeriesMetricType._DESERIALIZER, "time_series_metric");
        op.add(AbstractBuilder::timeSeriesDimension, JsonpDeserializer.booleanDeserializer(), "time_series_dimension");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends DocValuesPropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean coerce;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean index;
        @Nullable
        private OnScriptError onScriptError;
        @Nullable
        private Script script;
        @Nullable
        private TimeSeriesMetricType timeSeriesMetric;
        @Nullable
        private Boolean timeSeriesDimension;

        protected AbstractBuilder() {
        }

        public final BuilderT boost(@Nullable Double value) {
            this.boost = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT coerce(@Nullable Boolean value) {
            this.coerce = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT index(@Nullable Boolean value) {
            this.index = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT onScriptError(@Nullable OnScriptError value) {
            this.onScriptError = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT script(@Nullable Script value) {
            this.script = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final BuilderT timeSeriesMetric(@Nullable TimeSeriesMetricType value) {
            this.timeSeriesMetric = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT timeSeriesDimension(@Nullable Boolean value) {
            this.timeSeriesDimension = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

