/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.bulk;

import co.elastic.clients.elasticsearch.core.bulk.BulkOperationBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class WriteOperation
extends BulkOperationBase {
    private final Map<String, String> dynamicTemplates;
    @Nullable
    private final String pipeline;
    @Nullable
    private final Boolean requireAlias;

    protected WriteOperation(AbstractBuilder<?> builder) {
        super(builder);
        this.dynamicTemplates = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).dynamicTemplates);
        this.pipeline = ((AbstractBuilder)builder).pipeline;
        this.requireAlias = ((AbstractBuilder)builder).requireAlias;
    }

    public final Map<String, String> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.dynamicTemplates)) {
            generator.writeKey("dynamic_templates");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.dynamicTemplates.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
        if (this.requireAlias != null) {
            generator.writeKey("require_alias");
            generator.write(this.requireAlias);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupWriteOperationDeserializer(ObjectDeserializer<BuilderT> op) {
        BulkOperationBase.setupBulkOperationBaseDeserializer(op);
        op.add(AbstractBuilder::dynamicTemplates, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "dynamic_templates");
        op.add(AbstractBuilder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
        op.add(AbstractBuilder::requireAlias, JsonpDeserializer.booleanDeserializer(), "require_alias");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends BulkOperationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Map<String, String> dynamicTemplates;
        @Nullable
        private String pipeline;
        @Nullable
        private Boolean requireAlias;

        protected AbstractBuilder() {
        }

        public final BuilderT dynamicTemplates(Map<String, String> map) {
            this.dynamicTemplates = AbstractBuilder._mapPutAll(this.dynamicTemplates, map);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT dynamicTemplates(String key, String value) {
            this.dynamicTemplates = AbstractBuilder._mapPut(this.dynamicTemplates, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT pipeline(@Nullable String value) {
            this.pipeline = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

