/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class RolloverResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final Map<String, Boolean> conditions;
    private final boolean dryRun;
    private final String newIndex;
    private final String oldIndex;
    private final boolean rolledOver;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<RolloverResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverResponse::setupRolloverResponseDeserializer);

    private RolloverResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, this, "acknowledged");
        this.conditions = ApiTypeHelper.unmodifiableRequired(builder.conditions, (Object)this, "conditions");
        this.dryRun = ApiTypeHelper.requireNonNull(builder.dryRun, this, "dryRun");
        this.newIndex = ApiTypeHelper.requireNonNull(builder.newIndex, this, "newIndex");
        this.oldIndex = ApiTypeHelper.requireNonNull(builder.oldIndex, this, "oldIndex");
        this.rolledOver = ApiTypeHelper.requireNonNull(builder.rolledOver, this, "rolledOver");
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, this, "shardsAcknowledged");
    }

    public static RolloverResponse of(Function<Builder, ObjectBuilder<RolloverResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final Map<String, Boolean> conditions() {
        return this.conditions;
    }

    public final boolean dryRun() {
        return this.dryRun;
    }

    public final String newIndex() {
        return this.newIndex;
    }

    public final String oldIndex() {
        return this.oldIndex;
    }

    public final boolean rolledOver() {
        return this.rolledOver;
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        if (ApiTypeHelper.isDefined(this.conditions)) {
            generator.writeKey("conditions");
            generator.writeStartObject();
            for (Map.Entry<String, Boolean> item0 : this.conditions.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("dry_run");
        generator.write(this.dryRun);
        generator.writeKey("new_index");
        generator.write(this.newIndex);
        generator.writeKey("old_index");
        generator.write(this.oldIndex);
        generator.writeKey("rolled_over");
        generator.write(this.rolledOver);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRolloverResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::conditions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.booleanDeserializer()), "conditions");
        op.add(Builder::dryRun, JsonpDeserializer.booleanDeserializer(), "dry_run");
        op.add(Builder::newIndex, JsonpDeserializer.stringDeserializer(), "new_index");
        op.add(Builder::oldIndex, JsonpDeserializer.stringDeserializer(), "old_index");
        op.add(Builder::rolledOver, JsonpDeserializer.booleanDeserializer(), "rolled_over");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RolloverResponse> {
        private Boolean acknowledged;
        private Map<String, Boolean> conditions;
        private Boolean dryRun;
        private String newIndex;
        private String oldIndex;
        private Boolean rolledOver;
        private Boolean shardsAcknowledged;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder conditions(Map<String, Boolean> map) {
            this.conditions = Builder._mapPutAll(this.conditions, map);
            return this;
        }

        public final Builder conditions(String key, Boolean value) {
            this.conditions = Builder._mapPut(this.conditions, key, value);
            return this;
        }

        public final Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        public final Builder newIndex(String value) {
            this.newIndex = value;
            return this;
        }

        public final Builder oldIndex(String value) {
            this.oldIndex = value;
            return this;
        }

        public final Builder rolledOver(boolean value) {
            this.rolledOver = value;
            return this;
        }

        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RolloverResponse build() {
            this._checkSingleUse();
            return new RolloverResponse(this);
        }
    }
}

