/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.rollover;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RolloverConditions
implements JsonpSerializable {
    @Nullable
    private final Time minAge;
    @Nullable
    private final Time maxAge;
    @Nullable
    private final Long maxAgeMillis;
    @Nullable
    private final Long minDocs;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final String maxSize;
    @Nullable
    private final String minSize;
    @Nullable
    private final String maxSizeBytes;
    @Nullable
    private final String maxPrimaryShardSize;
    @Nullable
    private final String minPrimaryShardSize;
    @Nullable
    private final Long maxPrimaryShardDocs;
    @Nullable
    private final Long minPrimaryShardDocs;
    public static final JsonpDeserializer<RolloverConditions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverConditions::setupRolloverConditionsDeserializer);

    private RolloverConditions(Builder builder) {
        this.minAge = builder.minAge;
        this.maxAge = builder.maxAge;
        this.maxAgeMillis = builder.maxAgeMillis;
        this.minDocs = builder.minDocs;
        this.maxDocs = builder.maxDocs;
        this.maxSize = builder.maxSize;
        this.minSize = builder.minSize;
        this.maxSizeBytes = builder.maxSizeBytes;
        this.maxPrimaryShardSize = builder.maxPrimaryShardSize;
        this.minPrimaryShardSize = builder.minPrimaryShardSize;
        this.maxPrimaryShardDocs = builder.maxPrimaryShardDocs;
        this.minPrimaryShardDocs = builder.minPrimaryShardDocs;
    }

    public static RolloverConditions of(Function<Builder, ObjectBuilder<RolloverConditions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time minAge() {
        return this.minAge;
    }

    @Nullable
    public final Time maxAge() {
        return this.maxAge;
    }

    @Nullable
    public final Long maxAgeMillis() {
        return this.maxAgeMillis;
    }

    @Nullable
    public final Long minDocs() {
        return this.minDocs;
    }

    @Nullable
    public final Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public final String maxSize() {
        return this.maxSize;
    }

    @Nullable
    public final String minSize() {
        return this.minSize;
    }

    @Nullable
    public final String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    @Nullable
    public final String maxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Nullable
    public final String minPrimaryShardSize() {
        return this.minPrimaryShardSize;
    }

    @Nullable
    public final Long maxPrimaryShardDocs() {
        return this.maxPrimaryShardDocs;
    }

    @Nullable
    public final Long minPrimaryShardDocs() {
        return this.minPrimaryShardDocs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.minAge != null) {
            generator.writeKey("min_age");
            this.minAge.serialize(generator, mapper);
        }
        if (this.maxAge != null) {
            generator.writeKey("max_age");
            this.maxAge.serialize(generator, mapper);
        }
        if (this.maxAgeMillis != null) {
            generator.writeKey("max_age_millis");
            generator.write(this.maxAgeMillis);
        }
        if (this.minDocs != null) {
            generator.writeKey("min_docs");
            generator.write(this.minDocs);
        }
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs);
        }
        if (this.maxSize != null) {
            generator.writeKey("max_size");
            generator.write(this.maxSize);
        }
        if (this.minSize != null) {
            generator.writeKey("min_size");
            generator.write(this.minSize);
        }
        if (this.maxSizeBytes != null) {
            generator.writeKey("max_size_bytes");
            generator.write(this.maxSizeBytes);
        }
        if (this.maxPrimaryShardSize != null) {
            generator.writeKey("max_primary_shard_size");
            generator.write(this.maxPrimaryShardSize);
        }
        if (this.minPrimaryShardSize != null) {
            generator.writeKey("min_primary_shard_size");
            generator.write(this.minPrimaryShardSize);
        }
        if (this.maxPrimaryShardDocs != null) {
            generator.writeKey("max_primary_shard_docs");
            generator.write(this.maxPrimaryShardDocs);
        }
        if (this.minPrimaryShardDocs != null) {
            generator.writeKey("min_primary_shard_docs");
            generator.write(this.minPrimaryShardDocs);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRolloverConditionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::minAge, Time._DESERIALIZER, "min_age");
        op.add(Builder::maxAge, Time._DESERIALIZER, "max_age");
        op.add(Builder::maxAgeMillis, JsonpDeserializer.longDeserializer(), "max_age_millis");
        op.add(Builder::minDocs, JsonpDeserializer.longDeserializer(), "min_docs");
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs");
        op.add(Builder::maxSize, JsonpDeserializer.stringDeserializer(), "max_size");
        op.add(Builder::minSize, JsonpDeserializer.stringDeserializer(), "min_size");
        op.add(Builder::maxSizeBytes, JsonpDeserializer.stringDeserializer(), "max_size_bytes");
        op.add(Builder::maxPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "max_primary_shard_size");
        op.add(Builder::minPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "min_primary_shard_size");
        op.add(Builder::maxPrimaryShardDocs, JsonpDeserializer.longDeserializer(), "max_primary_shard_docs");
        op.add(Builder::minPrimaryShardDocs, JsonpDeserializer.longDeserializer(), "min_primary_shard_docs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RolloverConditions> {
        @Nullable
        private Time minAge;
        @Nullable
        private Time maxAge;
        @Nullable
        private Long maxAgeMillis;
        @Nullable
        private Long minDocs;
        @Nullable
        private Long maxDocs;
        @Nullable
        private String maxSize;
        @Nullable
        private String minSize;
        @Nullable
        private String maxSizeBytes;
        @Nullable
        private String maxPrimaryShardSize;
        @Nullable
        private String minPrimaryShardSize;
        @Nullable
        private Long maxPrimaryShardDocs;
        @Nullable
        private Long minPrimaryShardDocs;

        public final Builder minAge(@Nullable Time value) {
            this.minAge = value;
            return this;
        }

        public final Builder minAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.minAge(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxAge(@Nullable Time value) {
            this.maxAge = value;
            return this;
        }

        public final Builder maxAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxAge(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxAgeMillis(@Nullable Long value) {
            this.maxAgeMillis = value;
            return this;
        }

        public final Builder minDocs(@Nullable Long value) {
            this.minDocs = value;
            return this;
        }

        public final Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public final Builder maxSize(@Nullable String value) {
            this.maxSize = value;
            return this;
        }

        public final Builder minSize(@Nullable String value) {
            this.minSize = value;
            return this;
        }

        public final Builder maxSizeBytes(@Nullable String value) {
            this.maxSizeBytes = value;
            return this;
        }

        public final Builder maxPrimaryShardSize(@Nullable String value) {
            this.maxPrimaryShardSize = value;
            return this;
        }

        public final Builder minPrimaryShardSize(@Nullable String value) {
            this.minPrimaryShardSize = value;
            return this;
        }

        public final Builder maxPrimaryShardDocs(@Nullable Long value) {
            this.maxPrimaryShardDocs = value;
            return this;
        }

        public final Builder minPrimaryShardDocs(@Nullable Long value) {
            this.minPrimaryShardDocs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RolloverConditions build() {
            this._checkSingleUse();
            return new RolloverConditions(this);
        }
    }
}

