/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisAnalyzedFields;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsDestination;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.elasticsearch.ml.ExplainDataFrameAnalyticsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExplainDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowLazyStart;
    @Nullable
    private final DataframeAnalysis analysis;
    @Nullable
    private final DataframeAnalysisAnalyzedFields analyzedFields;
    @Nullable
    private final String description;
    @Nullable
    private final DataframeAnalyticsDestination dest;
    @Nullable
    private final String id;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final String modelMemoryLimit;
    @Nullable
    private final DataframeAnalyticsSource source;
    public static final JsonpDeserializer<ExplainDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplainDataFrameAnalyticsRequest::setupExplainDataFrameAnalyticsRequestDeserializer);
    public static final Endpoint<ExplainDataFrameAnalyticsRequest, ExplainDataFrameAnalyticsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ExplainDataFrameAnalyticsRequest, ExplainDataFrameAnalyticsResponse>("es/ml.explain_data_frame_analytics", request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/_explain");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_explain");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ExplainDataFrameAnalyticsResponse._DESERIALIZER);

    private ExplainDataFrameAnalyticsRequest(Builder builder) {
        this.allowLazyStart = builder.allowLazyStart;
        this.analysis = builder.analysis;
        this.analyzedFields = builder.analyzedFields;
        this.description = builder.description;
        this.dest = builder.dest;
        this.id = builder.id;
        this.maxNumThreads = builder.maxNumThreads;
        this.modelMemoryLimit = builder.modelMemoryLimit;
        this.source = builder.source;
    }

    public static ExplainDataFrameAnalyticsRequest of(Function<Builder, ObjectBuilder<ExplainDataFrameAnalyticsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    @Nullable
    public final DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public final DataframeAnalysisAnalyzedFields analyzedFields() {
        return this.analyzedFields;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final DataframeAnalyticsDestination dest() {
        return this.dest;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public final String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public final DataframeAnalyticsSource source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowLazyStart != null) {
            generator.writeKey("allow_lazy_start");
            generator.write(this.allowLazyStart);
        }
        if (this.analysis != null) {
            generator.writeKey("analysis");
            this.analysis.serialize(generator, mapper);
        }
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            this.analyzedFields.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.dest != null) {
            generator.writeKey("dest");
            this.dest.serialize(generator, mapper);
        }
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads);
        }
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
    }

    protected static void setupExplainDataFrameAnalyticsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start");
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis");
        op.add(Builder::analyzedFields, DataframeAnalysisAnalyzedFields._DESERIALIZER, "analyzed_fields");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dest, DataframeAnalyticsDestination._DESERIALIZER, "dest");
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads");
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit");
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExplainDataFrameAnalyticsRequest> {
        @Nullable
        private Boolean allowLazyStart;
        @Nullable
        private DataframeAnalysis analysis;
        @Nullable
        private DataframeAnalysisAnalyzedFields analyzedFields;
        @Nullable
        private String description;
        @Nullable
        private DataframeAnalyticsDestination dest;
        @Nullable
        private String id;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private String modelMemoryLimit;
        @Nullable
        private DataframeAnalyticsSource source;

        public final Builder allowLazyStart(@Nullable Boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        public final Builder analysis(@Nullable DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public final Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public final Builder analyzedFields(@Nullable DataframeAnalysisAnalyzedFields value) {
            this.analyzedFields = value;
            return this;
        }

        public final Builder analyzedFields(Function<DataframeAnalysisAnalyzedFields.Builder, ObjectBuilder<DataframeAnalysisAnalyzedFields>> fn) {
            return this.analyzedFields(fn.apply(new DataframeAnalysisAnalyzedFields.Builder()).build());
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder dest(@Nullable DataframeAnalyticsDestination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<DataframeAnalyticsDestination.Builder, ObjectBuilder<DataframeAnalyticsDestination>> fn) {
            return this.dest(fn.apply(new DataframeAnalyticsDestination.Builder()).build());
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public final Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public final Builder source(@Nullable DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExplainDataFrameAnalyticsRequest build() {
            this._checkSingleUse();
            return new ExplainDataFrameAnalyticsRequest(this);
        }
    }
}

