/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisAnalyzedFields;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsDestination;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.elasticsearch.ml.PutDataFrameAnalyticsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowLazyStart;
    private final DataframeAnalysis analysis;
    @Nullable
    private final DataframeAnalysisAnalyzedFields analyzedFields;
    @Nullable
    private final String description;
    private final DataframeAnalyticsDestination dest;
    private final Map<String, List<String>> headers;
    private final String id;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final String modelMemoryLimit;
    private final DataframeAnalyticsSource source;
    @Nullable
    private final String version;
    public static final JsonpDeserializer<PutDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDataFrameAnalyticsRequest::setupPutDataFrameAnalyticsRequestDeserializer);
    public static final Endpoint<PutDataFrameAnalyticsRequest, PutDataFrameAnalyticsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutDataFrameAnalyticsRequest, PutDataFrameAnalyticsResponse>("es/ml.put_data_frame_analytics", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutDataFrameAnalyticsResponse._DESERIALIZER);

    private PutDataFrameAnalyticsRequest(Builder builder) {
        this.allowLazyStart = builder.allowLazyStart;
        this.analysis = ApiTypeHelper.requireNonNull(builder.analysis, this, "analysis");
        this.analyzedFields = builder.analyzedFields;
        this.description = builder.description;
        this.dest = ApiTypeHelper.requireNonNull(builder.dest, this, "dest");
        this.headers = ApiTypeHelper.unmodifiable(builder.headers);
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.maxNumThreads = builder.maxNumThreads;
        this.modelMemoryLimit = builder.modelMemoryLimit;
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.version = builder.version;
    }

    public static PutDataFrameAnalyticsRequest of(Function<Builder, ObjectBuilder<PutDataFrameAnalyticsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    public final DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public final DataframeAnalysisAnalyzedFields analyzedFields() {
        return this.analyzedFields;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final DataframeAnalyticsDestination dest() {
        return this.dest;
    }

    public final Map<String, List<String>> headers() {
        return this.headers;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public final String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public final DataframeAnalyticsSource source() {
        return this.source;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowLazyStart != null) {
            generator.writeKey("allow_lazy_start");
            generator.write(this.allowLazyStart);
        }
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            this.analyzedFields.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (String item1 : item0.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads);
        }
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
    }

    protected static void setupPutDataFrameAnalyticsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start");
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis");
        op.add(Builder::analyzedFields, DataframeAnalysisAnalyzedFields._DESERIALIZER, "analyzed_fields");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dest, DataframeAnalyticsDestination._DESERIALIZER, "dest");
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "headers");
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads");
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit");
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutDataFrameAnalyticsRequest> {
        @Nullable
        private Boolean allowLazyStart;
        private DataframeAnalysis analysis;
        @Nullable
        private DataframeAnalysisAnalyzedFields analyzedFields;
        @Nullable
        private String description;
        private DataframeAnalyticsDestination dest;
        @Nullable
        private Map<String, List<String>> headers;
        private String id;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private String modelMemoryLimit;
        private DataframeAnalyticsSource source;
        @Nullable
        private String version;

        public final Builder allowLazyStart(@Nullable Boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        public final Builder analysis(DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public final Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public final Builder analyzedFields(@Nullable DataframeAnalysisAnalyzedFields value) {
            this.analyzedFields = value;
            return this;
        }

        public final Builder analyzedFields(Function<DataframeAnalysisAnalyzedFields.Builder, ObjectBuilder<DataframeAnalysisAnalyzedFields>> fn) {
            return this.analyzedFields(fn.apply(new DataframeAnalysisAnalyzedFields.Builder()).build());
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder dest(DataframeAnalyticsDestination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<DataframeAnalyticsDestination.Builder, ObjectBuilder<DataframeAnalyticsDestination>> fn) {
            return this.dest(fn.apply(new DataframeAnalyticsDestination.Builder()).build());
        }

        public final Builder headers(Map<String, List<String>> map) {
            this.headers = Builder._mapPutAll(this.headers, map);
            return this;
        }

        public final Builder headers(String key, List<String> value) {
            this.headers = Builder._mapPut(this.headers, key, value);
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public final Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public final Builder source(DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDataFrameAnalyticsRequest build() {
            this._checkSingleUse();
            return new PutDataFrameAnalyticsRequest(this);
        }
    }
}

