/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.tasks.TaskStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TaskInfo
implements JsonpSerializable {
    private final String action;
    @Nullable
    private final Boolean cancelled;
    private final boolean cancellable;
    @Nullable
    private final String description;
    private final Map<String, String> headers;
    private final long id;
    private final String node;
    @Nullable
    private final Time runningTime;
    private final long runningTimeInNanos;
    private final long startTimeInMillis;
    @Nullable
    private final TaskStatus status;
    private final String type;
    @Nullable
    private final String parentTaskId;
    public static final JsonpDeserializer<TaskInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TaskInfo::setupTaskInfoDeserializer);

    protected TaskInfo(AbstractBuilder<?> builder) {
        this.action = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).action, this, "action");
        this.cancelled = ((AbstractBuilder)builder).cancelled;
        this.cancellable = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).cancellable, this, "cancellable");
        this.description = ((AbstractBuilder)builder).description;
        this.headers = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).headers, (Object)this, "headers");
        this.id = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).id, this, "id");
        this.node = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).node, this, "node");
        this.runningTime = ((AbstractBuilder)builder).runningTime;
        this.runningTimeInNanos = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).runningTimeInNanos, this, "runningTimeInNanos");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).startTimeInMillis, this, "startTimeInMillis");
        this.status = ((AbstractBuilder)builder).status;
        this.type = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).type, this, "type");
        this.parentTaskId = ((AbstractBuilder)builder).parentTaskId;
    }

    public static TaskInfo taskInfoOf(Function<Builder, ObjectBuilder<TaskInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String action() {
        return this.action;
    }

    @Nullable
    public final Boolean cancelled() {
        return this.cancelled;
    }

    public final boolean cancellable() {
        return this.cancellable;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final Map<String, String> headers() {
        return this.headers;
    }

    public final long id() {
        return this.id;
    }

    public final String node() {
        return this.node;
    }

    @Nullable
    public final Time runningTime() {
        return this.runningTime;
    }

    public final long runningTimeInNanos() {
        return this.runningTimeInNanos;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final TaskStatus status() {
        return this.status;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final String parentTaskId() {
        return this.parentTaskId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("action");
        generator.write(this.action);
        if (this.cancelled != null) {
            generator.writeKey("cancelled");
            generator.write(this.cancelled);
        }
        generator.writeKey("cancellable");
        generator.write(this.cancellable);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("node");
        generator.write(this.node);
        if (this.runningTime != null) {
            generator.writeKey("running_time");
            this.runningTime.serialize(generator, mapper);
        }
        generator.writeKey("running_time_in_nanos");
        generator.write(this.runningTimeInNanos);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        generator.writeKey("type");
        generator.write(this.type);
        if (this.parentTaskId != null) {
            generator.writeKey("parent_task_id");
            generator.write(this.parentTaskId);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupTaskInfoDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::action, JsonpDeserializer.stringDeserializer(), "action");
        op.add(AbstractBuilder::cancelled, JsonpDeserializer.booleanDeserializer(), "cancelled");
        op.add(AbstractBuilder::cancellable, JsonpDeserializer.booleanDeserializer(), "cancellable");
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(AbstractBuilder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "headers");
        op.add(AbstractBuilder::id, JsonpDeserializer.longDeserializer(), "id");
        op.add(AbstractBuilder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(AbstractBuilder::runningTime, Time._DESERIALIZER, "running_time");
        op.add(AbstractBuilder::runningTimeInNanos, JsonpDeserializer.longDeserializer(), "running_time_in_nanos");
        op.add(AbstractBuilder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(AbstractBuilder::status, TaskStatus._DESERIALIZER, "status");
        op.add(AbstractBuilder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(AbstractBuilder::parentTaskId, JsonpDeserializer.stringDeserializer(), "parent_task_id");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String action;
        @Nullable
        private Boolean cancelled;
        private Boolean cancellable;
        @Nullable
        private String description;
        private Map<String, String> headers;
        private Long id;
        private String node;
        @Nullable
        private Time runningTime;
        private Long runningTimeInNanos;
        private Long startTimeInMillis;
        @Nullable
        private TaskStatus status;
        private String type;
        @Nullable
        private String parentTaskId;

        protected AbstractBuilder() {
        }

        public final BuilderT action(String value) {
            this.action = value;
            return (BuilderT)this.self();
        }

        public final BuilderT cancelled(@Nullable Boolean value) {
            this.cancelled = value;
            return (BuilderT)this.self();
        }

        public final BuilderT cancellable(boolean value) {
            this.cancellable = value;
            return (BuilderT)this.self();
        }

        public final BuilderT description(@Nullable String value) {
            this.description = value;
            return (BuilderT)this.self();
        }

        public final BuilderT headers(Map<String, String> map) {
            this.headers = AbstractBuilder._mapPutAll(this.headers, map);
            return (BuilderT)this.self();
        }

        public final BuilderT headers(String key, String value) {
            this.headers = AbstractBuilder._mapPut(this.headers, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT id(long value) {
            this.id = value;
            return (BuilderT)this.self();
        }

        public final BuilderT node(String value) {
            this.node = value;
            return (BuilderT)this.self();
        }

        public final BuilderT runningTime(@Nullable Time value) {
            this.runningTime = value;
            return (BuilderT)this.self();
        }

        public final BuilderT runningTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.runningTime(fn.apply(new Time.Builder()).build());
        }

        public final BuilderT runningTimeInNanos(long value) {
            this.runningTimeInNanos = value;
            return (BuilderT)this.self();
        }

        public final BuilderT startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return (BuilderT)this.self();
        }

        public final BuilderT status(@Nullable TaskStatus value) {
            this.status = value;
            return (BuilderT)this.self();
        }

        public final BuilderT status(Function<TaskStatus.Builder, ObjectBuilder<TaskStatus>> fn) {
            return this.status(fn.apply(new TaskStatus.Builder()).build());
        }

        public final BuilderT type(String value) {
            this.type = value;
            return (BuilderT)this.self();
        }

        public final BuilderT parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<TaskInfo> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TaskInfo build() {
            this._checkSingleUse();
            return new TaskInfo(this);
        }
    }
}

