/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.StringReader;
import java.io.StringWriter;

class JsonDataImpl
implements JsonData {
    private final Object value;
    private final JsonpMapper mapper;

    JsonDataImpl(Object value, JsonpMapper mapper) {
        this.value = value;
        this.mapper = mapper;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public JsonValue toJson() {
        return this.toJson(null);
    }

    @Override
    public JsonValue toJson(JsonpMapper mapper) {
        if (this.value instanceof JsonValue) {
            return (JsonValue)this.value;
        }
        JsonpMapper jsonpMapper = mapper = mapper != null ? mapper : this.mapper;
        if (mapper == null) {
            throw new IllegalStateException("Contains a '" + this.value.getClass().getName() + "' that cannot be converted to a JsonValue without a mapper");
        }
        JsonParser parser = this.getParser(mapper);
        parser.next();
        return parser.getValue();
    }

    @Override
    public <T> T to(Class<T> clazz) {
        return this.to(clazz, null);
    }

    @Override
    public <T> T to(Class<T> clazz, JsonpMapper mapper) {
        if (clazz.isAssignableFrom(this.value.getClass())) {
            return (T)this.value;
        }
        mapper = this.getMapper(mapper);
        JsonParser parser = this.getParser(mapper);
        return mapper.deserialize(parser, clazz);
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer) {
        return this.deserialize(deserializer, null);
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer, JsonpMapper mapper) {
        mapper = this.getMapper(mapper);
        return deserializer.deserialize(this.getParser(mapper), mapper);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this.value instanceof JsonValue) {
            generator.write((JsonValue)this.value);
        } else if (this.mapper == null) {
            mapper.serialize(this.value, generator);
        } else if (this.mapper.getClass() != mapper.getClass()) {
            mapper.serialize(this.value, generator);
        } else {
            this.mapper.serialize(this.value, generator);
        }
    }

    private JsonpMapper getMapper(JsonpMapper localMapper) {
        JsonpMapper jsonpMapper = localMapper = localMapper != null ? localMapper : this.mapper;
        if (localMapper == null) {
            throw new IllegalStateException("A JsonpMapper is needed to convert JsonData");
        }
        return localMapper;
    }

    private JsonParser getParser(JsonpMapper mapper) {
        StringWriter sw = new StringWriter();
        JsonGenerator generator = mapper.jsonProvider().createGenerator(sw);
        if (this.value instanceof JsonValue) {
            generator.write((JsonValue)this.value);
        } else {
            mapper.serialize(this.value, generator);
        }
        generator.close();
        return mapper.jsonProvider().createParser(new StringReader(sw.toString()));
    }
}

