/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.Version;
import co.elastic.clients.transport.rest_client.LanguageRuntimeVersions;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.util.VersionInfo;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.WarningsHandler;

public class RestClientOptions
implements TransportOptions {
    private final RequestOptions options;
    private static final String CLIENT_META_HEADER = "X-Elastic-Client-Meta";
    private static final String USER_AGENT_HEADER = "User-Agent";
    static final String CLIENT_META_VALUE = RestClientOptions.getClientMeta();
    static final String USER_AGENT_VALUE = RestClientOptions.getUserAgent();

    static RestClientOptions of(TransportOptions options) {
        if (options instanceof RestClientOptions) {
            return (RestClientOptions)options;
        }
        Builder builder = new Builder(RequestOptions.DEFAULT.toBuilder());
        options.headers().forEach(h -> builder.addHeader((String)h.getKey(), (String)h.getValue()));
        options.queryParameters().forEach(builder::setParameter);
        builder.onWarnings(options.onWarnings());
        return builder.build();
    }

    public RestClientOptions(RequestOptions options) {
        this.options = RestClientOptions.addBuiltinHeaders(options.toBuilder()).build();
    }

    public RequestOptions restClientRequestOptions() {
        return this.options;
    }

    @Override
    public Collection<Map.Entry<String, String>> headers() {
        return this.options.getHeaders().stream().map(h -> new AbstractMap.SimpleImmutableEntry<String, String>(h.getName(), h.getValue())).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> queryParameters() {
        return this.options.getParameters();
    }

    @Override
    public Function<List<String>, Boolean> onWarnings() {
        WarningsHandler handler = this.options.getWarningsHandler();
        if (handler == null) {
            return null;
        }
        return warnings -> this.options.getWarningsHandler().warningsShouldFailRequest((List<String>)warnings);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.options.toBuilder());
    }

    static RestClientOptions initialOptions() {
        return new RestClientOptions(RequestOptions.DEFAULT);
    }

    private static RequestOptions.Builder addBuiltinHeaders(RequestOptions.Builder builder) {
        builder.removeHeader(CLIENT_META_HEADER);
        builder.addHeader(CLIENT_META_HEADER, CLIENT_META_VALUE);
        if (builder.getHeaders().stream().noneMatch(h -> h.getName().equalsIgnoreCase(USER_AGENT_HEADER))) {
            builder.addHeader(USER_AGENT_HEADER, USER_AGENT_VALUE);
        }
        if (builder.getHeaders().stream().noneMatch(h -> h.getName().equalsIgnoreCase("Accept"))) {
            builder.addHeader("Accept", RestClientTransport.JsonContentType.toString());
        }
        return builder;
    }

    private static String getUserAgent() {
        return String.format(Locale.ROOT, "elastic-java/%s (Java/%s)", Version.VERSION == null ? "Unknown" : Version.VERSION.toString(), System.getProperty("java.version"));
    }

    private static String getClientMeta() {
        VersionInfo httpClientVersion = null;
        try {
            httpClientVersion = VersionInfo.loadVersionInfo("org.apache.http.nio.client", HttpAsyncClientBuilder.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String metaVersion = Version.VERSION == null ? "" : Version.VERSION.toString();
        int dashPos = metaVersion.indexOf(45);
        if (dashPos > 0) {
            metaVersion = metaVersion.substring(0, dashPos) + "p";
        }
        return "es=" + metaVersion + ",jv=" + System.getProperty("java.specification.version") + ",hl=2,t=" + metaVersion + ",hc=" + (httpClientVersion == null ? "" : httpClientVersion.getRelease()) + LanguageRuntimeVersions.getRuntimeMetadata();
    }

    public static class Builder
    implements TransportOptions.Builder {
        private RequestOptions.Builder builder;

        public Builder(RequestOptions.Builder builder) {
            this.builder = builder;
        }

        public RequestOptions.Builder restClientRequestOptionsBuilder() {
            return this.builder;
        }

        @Override
        public TransportOptions.Builder addHeader(String name, String value) {
            if (name.equalsIgnoreCase(RestClientOptions.CLIENT_META_HEADER)) {
                return this;
            }
            if (name.equalsIgnoreCase(RestClientOptions.USER_AGENT_HEADER)) {
                this.builder.removeHeader(RestClientOptions.USER_AGENT_HEADER);
            }
            this.builder.addHeader(name, value);
            return this;
        }

        @Override
        public TransportOptions.Builder setParameter(String name, String value) {
            this.builder.addParameter(name, value);
            return this;
        }

        @Override
        public TransportOptions.Builder onWarnings(Function<List<String>, Boolean> listener) {
            if (listener == null) {
                this.builder.setWarningsHandler(null);
            } else {
                this.builder.setWarningsHandler(w -> {
                    if (w != null && !w.isEmpty()) {
                        return (Boolean)listener.apply(w);
                    }
                    return false;
                });
            }
            return this;
        }

        @Override
        public RestClientOptions build() {
            return new RestClientOptions(RestClientOptions.addBuiltinHeaders(this.builder).build());
        }
    }
}

