/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.es.aggregation;

import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;

public class BulkRequestAggregationStrategy
implements AggregationStrategy {
    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Object objBody = newExchange.getIn().getBody();
        if (!(objBody instanceof BulkOperation[])) {
            throw new InvalidPayloadRuntimeException(newExchange, BulkOperation[].class);
        }
        BulkOperation[] newBody = (BulkOperation[])objBody;
        BulkRequest.Builder builder = new BulkRequest.Builder();
        builder.operations(List.of(newBody));
        if (oldExchange != null) {
            BulkRequest request = oldExchange.getIn().getBody(BulkRequest.class);
            builder.operations(request.operations());
        }
        newExchange.getIn().setBody(builder.build());
        return oldExchange;
    }
}

