/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch5.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class ElasticsearchActionRequestConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchActionRequestConverter.class);

    private ElasticsearchActionRequestConverter() {
    }

    private static UpdateRequest createUpdateRequest(Object document, Exchange exchange) {
        if (document instanceof UpdateRequest) {
            return (UpdateRequest)document;
        }
        UpdateRequest updateRequest = new UpdateRequest();
        if (document instanceof byte[]) {
            updateRequest.doc((byte[])document);
        } else if (document instanceof Map) {
            updateRequest.doc((Map)document);
        } else if (document instanceof String) {
            updateRequest.doc((String)document);
        } else if (document instanceof XContentBuilder) {
            updateRequest.doc((XContentBuilder)document);
        } else {
            return null;
        }
        return ((UpdateRequest)updateRequest.waitForActiveShards((Integer)exchange.getIn().getHeader("waitForActiveShards", Integer.class)).parent((String)exchange.getIn().getHeader("parent", String.class)).index((String)exchange.getIn().getHeader("indexName", String.class))).type((String)exchange.getIn().getHeader("indexType", String.class)).id((String)exchange.getIn().getHeader("indexId", String.class));
    }

    private static IndexRequest createIndexRequest(Object document, Exchange exchange) {
        if (document instanceof IndexRequest) {
            return (IndexRequest)document;
        }
        IndexRequest indexRequest = new IndexRequest();
        if (document instanceof byte[]) {
            indexRequest.source((byte[])document);
        } else if (document instanceof Map) {
            indexRequest.source((Map)document);
        } else if (document instanceof String) {
            indexRequest.source((String)document);
        } else if (document instanceof XContentBuilder) {
            indexRequest.source((XContentBuilder)document);
        } else {
            return null;
        }
        return ((IndexRequest)((IndexRequest)indexRequest.waitForActiveShards((Integer)exchange.getIn().getHeader("waitForActiveShards", Integer.class))).parent((String)exchange.getIn().getHeader("parent", String.class)).index((String)exchange.getIn().getHeader("indexName", String.class))).type((String)exchange.getIn().getHeader("indexType", String.class));
    }

    @Converter
    public static IndexRequest toIndexRequest(Object document, Exchange exchange) {
        return ElasticsearchActionRequestConverter.createIndexRequest(document, exchange).id((String)exchange.getIn().getHeader("indexId", String.class));
    }

    @Converter
    public static UpdateRequest toUpdateRequest(Object document, Exchange exchange) {
        return ElasticsearchActionRequestConverter.createUpdateRequest(document, exchange).id((String)exchange.getIn().getHeader("indexId", String.class));
    }

    @Converter
    public static GetRequest toGetRequest(String id, Exchange exchange) {
        return new GetRequest((String)exchange.getIn().getHeader("indexName", String.class)).type((String)exchange.getIn().getHeader("indexType", String.class)).id(id);
    }

    @Converter
    public static MultiGetRequest toMultiGetRequest(Object document, Exchange exchange) {
        List items = (List)document;
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        for (MultiGetRequest.Item item : items) {
            multiGetRequest.add(item);
        }
        return multiGetRequest;
    }

    @Converter
    public static MultiSearchRequest toMultiSearchRequest(Object document, Exchange exchange) {
        List items = (List)document;
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (SearchRequest item : items) {
            multiSearchRequest.add(item);
        }
        return multiSearchRequest;
    }

    @Converter
    public static DeleteRequest toDeleteRequest(String id, Exchange exchange) {
        return ((DeleteRequest)new DeleteRequest().index((String)exchange.getIn().getHeader("indexName", String.class))).type((String)exchange.getIn().getHeader("indexType", String.class)).id(id);
    }

    @Converter
    public static DeleteIndexRequest toDeleteIndexRequest(String id, Exchange exchange) {
        return new DeleteIndexRequest().indices((String)exchange.getIn().getHeader("indexName", String.class));
    }

    @Converter
    public static SearchRequest toSearchRequest(Object queryObject, Exchange exchange) {
        SearchRequest searchRequest = new SearchRequest((String)exchange.getIn().getHeader("indexName", String.class)).types((String)exchange.getIn().getHeader("indexType", String.class));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        String queryText = null;
        Integer size = null;
        Integer from = null;
        if (queryObject instanceof Map) {
            Map mapQuery = (Map)queryObject;
            if (mapQuery.containsKey("size")) {
                size = (Integer)exchange.getContext().getTypeConverter().tryConvertTo(Integer.class, mapQuery.get("size"));
            }
            if (mapQuery.containsKey("from")) {
                from = (Integer)exchange.getContext().getTypeConverter().tryConvertTo(Integer.class, mapQuery.get("from"));
            }
            if (mapQuery.containsKey("query")) {
                mapQuery = (Map)mapQuery.get("query");
            }
            try {
                XContentBuilder contentBuilder = XContentFactory.contentBuilder(XContentType.JSON);
                queryText = contentBuilder.map(mapQuery).string();
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        } else if (queryObject instanceof String) {
            queryText = (String)queryObject;
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode fromNode;
                JsonNode sizeNode;
                JsonNode jsonTextObject = mapper.readValue(queryText, JsonNode.class);
                JsonNode parentJsonNode = jsonTextObject.get("query");
                if (parentJsonNode != null) {
                    queryText = parentJsonNode.toString();
                }
                if ((sizeNode = jsonTextObject.get("size")) != null) {
                    size = sizeNode.asInt();
                }
                if ((fromNode = jsonTextObject.get("from")) != null) {
                    from = fromNode.asInt();
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        } else {
            return null;
        }
        searchSourceBuilder.query(QueryBuilders.wrapperQuery(queryText));
        if (size != null) {
            searchSourceBuilder.size(size);
        }
        if (from != null) {
            searchSourceBuilder.from(from);
        }
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    @Converter
    public static BulkRequest toBulkRequest(List<Object> documents, Exchange exchange) {
        BulkRequest request = new BulkRequest();
        for (Object document : documents) {
            request.add(ElasticsearchActionRequestConverter.createIndexRequest(document, exchange));
        }
        return request;
    }
}

