/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.AllGroupHeadsCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.SentinelIntSet;

public abstract class TermAllGroupHeadsCollector
extends AllGroupHeadsCollector<BytesRef> {
    private static final int DEFAULT_INITIAL_SIZE = 128;
    final String groupField;
    SortedDocValues groupIndex;
    LeafReaderContext readerContext;

    protected TermAllGroupHeadsCollector(String groupField, int numberOfSorts) {
        super(numberOfSorts);
        this.groupField = groupField;
    }

    public static AllGroupHeadsCollector<BytesRef> create(String groupField, Sort sortWithinGroup) {
        return TermAllGroupHeadsCollector.create(groupField, sortWithinGroup, 128);
    }

    public static AllGroupHeadsCollector<BytesRef> create(String groupField, Sort sortWithinGroup, int initialSize) {
        boolean sortAllScore = true;
        boolean sortAllFieldValue = true;
        for (SortField sortField : sortWithinGroup.getSort()) {
            if (sortField.getType() == SortField.Type.SCORE) {
                sortAllFieldValue = false;
                continue;
            }
            if (TermAllGroupHeadsCollector.needGeneralImpl(sortField)) {
                return new GeneralAllGroupHeadsCollector(groupField, sortWithinGroup);
            }
            sortAllScore = false;
        }
        if (sortAllScore) {
            return new ScoreAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
        }
        if (sortAllFieldValue) {
            return new OrdAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
        }
        return new OrdScoreAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
    }

    private static boolean needGeneralImpl(SortField sortField) {
        SortField.Type sortType = sortField.getType();
        return sortType != SortField.Type.STRING_VAL && sortType != SortField.Type.STRING && sortType != SortField.Type.SCORE;
    }

    static class ScoreAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector {
        final SentinelIntSet ordSet;
        final List<GroupHead> collectedGroups;
        final SortField[] fields;
        Scorer scorer;
        GroupHead[] segmentGroupHeads;

        ScoreAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -2);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.getOrd(doc);
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                BytesRef term = key == -1 ? null : BytesRef.deepCopyOf(this.groupIndex.lookupOrd(key));
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key + 1] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key + 1];
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.readerContext = context;
            this.groupIndex = DocValues.getSorted(context.reader(), this.groupField);
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.getValueCount() + 1];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int ord = collectedGroup.groupValue == null ? -1 : this.groupIndex.lookupTerm((BytesRef)collectedGroup.groupValue);
                if (collectedGroup.groupValue != null && ord < 0) continue;
                this.ordSet.put(ord);
                this.segmentGroupHeads[ord + 1] = collectedGroup;
            }
        }

        class GroupHead
        extends AllGroupHeadsCollector.GroupHead<BytesRef> {
            float[] scores;

            GroupHead(int doc, BytesRef groupValue) throws IOException {
                super(groupValue, doc + ScoreAllGroupHeadsCollector.this.readerContext.docBase);
                this.scores = new float[ScoreAllGroupHeadsCollector.this.fields.length];
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                for (int i = 0; i < this.scores.length; ++i) {
                    this.scores[i] = score;
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                if (this.scores[compIDX] < score) {
                    return 1;
                }
                if (this.scores[compIDX] > score) {
                    return -1;
                }
                return 0;
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                for (int i = 0; i < this.scores.length; ++i) {
                    this.scores[i] = score;
                }
                this.doc = doc + ScoreAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class OrdAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        SortedDocValues[] sortsIndex;
        GroupHead[] segmentGroupHeads;

        OrdAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -2);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            this.sortsIndex = new SortedDocValues[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.getOrd(doc);
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                BytesRef term = key == -1 ? null : BytesRef.deepCopyOf(this.groupIndex.lookupOrd(key));
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key + 1] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key + 1];
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.readerContext = context;
            this.groupIndex = DocValues.getSorted(context.reader(), this.groupField);
            for (int i = 0; i < this.fields.length; ++i) {
                this.sortsIndex[i] = DocValues.getSorted(context.reader(), this.fields[i].getField());
            }
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.getValueCount() + 1];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int groupOrd = collectedGroup.groupValue == null ? -1 : this.groupIndex.lookupTerm((BytesRef)collectedGroup.groupValue);
                if (collectedGroup.groupValue != null && groupOrd < 0) continue;
                this.ordSet.put(groupOrd);
                this.segmentGroupHeads[groupOrd + 1] = collectedGroup;
                for (int i = 0; i < this.sortsIndex.length; ++i) {
                    int sortOrd = collectedGroup.sortOrds[i] == -1 ? -1 : this.sortsIndex[i].lookupTerm(collectedGroup.sortValues[i].get());
                    collectedGroup.sortOrds[i] = sortOrd;
                }
            }
        }

        class GroupHead
        extends AllGroupHeadsCollector.GroupHead<BytesRef> {
            BytesRefBuilder[] sortValues;
            int[] sortOrds;

            GroupHead(int doc, BytesRef groupValue) {
                super(groupValue, doc + OrdAllGroupHeadsCollector.this.readerContext.docBase);
                this.sortValues = new BytesRefBuilder[OrdAllGroupHeadsCollector.this.sortsIndex.length];
                this.sortOrds = new int[OrdAllGroupHeadsCollector.this.sortsIndex.length];
                for (int i = 0; i < OrdAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    this.sortOrds[i] = OrdAllGroupHeadsCollector.this.sortsIndex[i].getOrd(doc);
                    this.sortValues[i] = new BytesRefBuilder();
                    this.sortValues[i].copyBytes(OrdAllGroupHeadsCollector.this.sortsIndex[i].get(doc));
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                if (this.sortOrds[compIDX] < 0) {
                    BytesRef term = OrdAllGroupHeadsCollector.this.sortsIndex[compIDX].get(doc);
                    return this.sortValues[compIDX].get().compareTo(term);
                }
                return this.sortOrds[compIDX] - OrdAllGroupHeadsCollector.this.sortsIndex[compIDX].getOrd(doc);
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (int i = 0; i < OrdAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    this.sortOrds[i] = OrdAllGroupHeadsCollector.this.sortsIndex[i].getOrd(doc);
                    this.sortValues[i].copyBytes(OrdAllGroupHeadsCollector.this.sortsIndex[i].get(doc));
                }
                this.doc = doc + OrdAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class OrdScoreAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        final SortField[] fields;
        SortedDocValues[] sortsIndex;
        Scorer scorer;
        private GroupHead[] segmentGroupHeads;

        OrdScoreAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -2);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            this.sortsIndex = new SortedDocValues[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.getOrd(doc);
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                BytesRef term = key == -1 ? null : BytesRef.deepCopyOf(this.groupIndex.lookupOrd(key));
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key + 1] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key + 1];
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.readerContext = context;
            this.groupIndex = DocValues.getSorted(context.reader(), this.groupField);
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].getType() == SortField.Type.SCORE) continue;
                this.sortsIndex[i] = DocValues.getSorted(context.reader(), this.fields[i].getField());
            }
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.getValueCount() + 1];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int ord = collectedGroup.groupValue == null ? -1 : this.groupIndex.lookupTerm((BytesRef)collectedGroup.groupValue);
                if (collectedGroup.groupValue != null && ord < 0) continue;
                this.ordSet.put(ord);
                this.segmentGroupHeads[ord + 1] = collectedGroup;
                for (int i = 0; i < this.sortsIndex.length; ++i) {
                    if (this.fields[i].getType() == SortField.Type.SCORE) continue;
                    int sortOrd = collectedGroup.sortValues[i] == null ? -1 : this.sortsIndex[i].lookupTerm(collectedGroup.sortValues[i].get());
                    collectedGroup.sortOrds[i] = sortOrd;
                }
            }
        }

        class GroupHead
        extends AllGroupHeadsCollector.GroupHead<BytesRef> {
            BytesRefBuilder[] sortValues;
            int[] sortOrds;
            float[] scores;

            GroupHead(int doc, BytesRef groupValue) throws IOException {
                super(groupValue, doc + OrdScoreAllGroupHeadsCollector.this.readerContext.docBase);
                this.sortValues = new BytesRefBuilder[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                this.sortOrds = new int[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                this.scores = new float[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                for (int i = 0; i < OrdScoreAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    if (OrdScoreAllGroupHeadsCollector.this.fields[i].getType() == SortField.Type.SCORE) {
                        this.scores[i] = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                        continue;
                    }
                    this.sortOrds[i] = OrdScoreAllGroupHeadsCollector.this.sortsIndex[i].getOrd(doc);
                    this.sortValues[i] = new BytesRefBuilder();
                    if (this.sortOrds[i] == -1) continue;
                    this.sortValues[i].copyBytes(OrdScoreAllGroupHeadsCollector.this.sortsIndex[i].get(doc));
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                if (OrdScoreAllGroupHeadsCollector.this.fields[compIDX].getType() == SortField.Type.SCORE) {
                    float score = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                    if (this.scores[compIDX] < score) {
                        return 1;
                    }
                    if (this.scores[compIDX] > score) {
                        return -1;
                    }
                    return 0;
                }
                if (this.sortOrds[compIDX] < 0) {
                    BytesRef term = OrdScoreAllGroupHeadsCollector.this.sortsIndex[compIDX].get(doc);
                    return this.sortValues[compIDX].get().compareTo(term);
                }
                return this.sortOrds[compIDX] - OrdScoreAllGroupHeadsCollector.this.sortsIndex[compIDX].getOrd(doc);
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (int i = 0; i < OrdScoreAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    if (OrdScoreAllGroupHeadsCollector.this.fields[i].getType() == SortField.Type.SCORE) {
                        this.scores[i] = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                        continue;
                    }
                    this.sortOrds[i] = OrdScoreAllGroupHeadsCollector.this.sortsIndex[i].getOrd(doc);
                    this.sortValues[i].copyBytes(OrdScoreAllGroupHeadsCollector.this.sortsIndex[i].get(doc));
                }
                this.doc = doc + OrdScoreAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class GeneralAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector {
        private final Sort sortWithinGroup;
        private final Map<BytesRef, GroupHead> groups;
        Scorer scorer;

        GeneralAllGroupHeadsCollector(String groupField, Sort sortWithinGroup) {
            super(groupField, sortWithinGroup.getSort().length);
            this.sortWithinGroup = sortWithinGroup;
            this.groups = new HashMap<BytesRef, GroupHead>();
            SortField[] sortFields = sortWithinGroup.getSort();
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
            }
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            int ord = this.groupIndex.getOrd(doc);
            BytesRef groupValue = ord == -1 ? null : this.groupIndex.lookupOrd(ord);
            GroupHead groupHead = this.groups.get(groupValue);
            if (groupHead == null) {
                groupValue = groupValue == null ? null : BytesRef.deepCopyOf(groupValue);
                groupHead = new GroupHead(groupValue, this.sortWithinGroup, doc);
                this.groups.put(groupValue, groupHead);
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.groups.values();
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.readerContext = context;
            this.groupIndex = DocValues.getSorted(context.reader(), this.groupField);
            for (GroupHead groupHead : this.groups.values()) {
                for (int i = 0; i < groupHead.comparators.length; ++i) {
                    groupHead.leafComparators[i] = groupHead.comparators[i].getLeafComparator(context);
                }
            }
        }

        @Override
        public boolean needsScores() {
            return this.sortWithinGroup.needsScores();
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            for (GroupHead groupHead : this.groups.values()) {
                for (LeafFieldComparator comparator : groupHead.leafComparators) {
                    comparator.setScorer(scorer);
                }
            }
        }

        class GroupHead
        extends AllGroupHeadsCollector.GroupHead<BytesRef> {
            final FieldComparator[] comparators;
            final LeafFieldComparator[] leafComparators;

            GroupHead(BytesRef groupValue, Sort sort, int doc) throws IOException {
                super(groupValue, doc + GeneralAllGroupHeadsCollector.this.readerContext.docBase);
                SortField[] sortFields = sort.getSort();
                this.comparators = new FieldComparator[sortFields.length];
                this.leafComparators = new LeafFieldComparator[sortFields.length];
                for (int i = 0; i < sortFields.length; ++i) {
                    this.comparators[i] = sortFields[i].getComparator(1, i);
                    this.leafComparators[i] = this.comparators[i].getLeafComparator(GeneralAllGroupHeadsCollector.this.readerContext);
                    this.leafComparators[i].setScorer(GeneralAllGroupHeadsCollector.this.scorer);
                    this.leafComparators[i].copy(0, doc);
                    this.leafComparators[i].setBottom(0);
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                return this.leafComparators[compIDX].compareBottom(doc);
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (LeafFieldComparator comparator : this.leafComparators) {
                    comparator.copy(0, doc);
                    comparator.setBottom(0);
                }
                this.doc = doc + GeneralAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }
}

