/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.logging.log4j.Level;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.settings.Settings;

public abstract class Command
implements Closeable {
    protected final String description;
    protected final OptionParser parser = new OptionParser();
    private final OptionSpec<Void> helpOption = this.parser.acceptsAll(Arrays.asList("h", "help"), "show help").forHelp();
    private final OptionSpec<Void> silentOption = this.parser.acceptsAll(Arrays.asList("s", "silent"), "show minimal output");
    private final OptionSpec<Void> verboseOption = this.parser.acceptsAll(Arrays.asList("v", "verbose"), "show verbose output").availableUnless(this.silentOption, new OptionSpec[0]);
    final SetOnce<Thread> shutdownHookThread = new SetOnce();

    public Command(String description) {
        this.description = description;
    }

    public final int main(String[] args, Terminal terminal) throws Exception {
        if (this.addShutdownHook()) {
            this.shutdownHookThread.set(new Thread(() -> {
                try {
                    this.close();
                }
                catch (IOException e) {
                    try (StringWriter sw = new StringWriter();
                         PrintWriter pw = new PrintWriter(sw);){
                        e.printStackTrace(pw);
                        terminal.println(sw.toString());
                    }
                    catch (IOException impossible) {
                        throw new AssertionError((Object)impossible);
                    }
                }
            }));
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread.get());
        }
        if (this.shouldConfigureLoggingWithoutConfig()) {
            String loggerLevel = System.getProperty("es.logger.level", Level.INFO.name());
            Settings settings = Settings.builder().put("logger.level", loggerLevel).build();
            LogConfigurator.configureWithoutConfig(settings);
        }
        try {
            this.mainWithoutErrorHandling(args, terminal);
        }
        catch (OptionException e) {
            this.printHelp(terminal);
            terminal.println(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage());
            return 64;
        }
        catch (UserException e) {
            if (e.exitCode == 64) {
                this.printHelp(terminal);
            }
            terminal.println(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage());
            return e.exitCode;
        }
        return 0;
    }

    protected boolean shouldConfigureLoggingWithoutConfig() {
        return true;
    }

    void mainWithoutErrorHandling(String[] args, Terminal terminal) throws Exception {
        OptionSet options = this.parser.parse(args);
        if (options.has(this.helpOption)) {
            this.printHelp(terminal);
            return;
        }
        if (options.has(this.silentOption)) {
            terminal.setVerbosity(Terminal.Verbosity.SILENT);
        } else if (options.has(this.verboseOption)) {
            terminal.setVerbosity(Terminal.Verbosity.VERBOSE);
        } else {
            terminal.setVerbosity(Terminal.Verbosity.NORMAL);
        }
        this.execute(terminal, options);
    }

    private void printHelp(Terminal terminal) throws IOException {
        terminal.println(this.description);
        terminal.println("");
        this.printAdditionalHelp(terminal);
        this.parser.printHelpOn(terminal.getWriter());
    }

    protected void printAdditionalHelp(Terminal terminal) {
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    protected static void exit(int status) {
        System.exit(status);
    }

    protected abstract void execute(Terminal var1, OptionSet var2) throws Exception;

    protected boolean addShutdownHook() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

