/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty3.cors;

import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.http.netty3.cors.Netty3CorsConfig;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class Netty3CorsHandler
extends SimpleChannelUpstreamHandler {
    public static final String ANY_ORIGIN = "*";
    private static Pattern SCHEME_PATTERN = Pattern.compile("^https?://");
    private final Netty3CorsConfig config;
    private HttpRequest request;

    public Netty3CorsHandler(Netty3CorsConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.config = config;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.config.isCorsSupportEnabled() && e.getMessage() instanceof HttpRequest) {
            this.request = (HttpRequest)e.getMessage();
            if (Netty3CorsHandler.isPreflightRequest(this.request)) {
                this.handlePreflight(ctx, this.request);
                return;
            }
            if (this.config.isShortCircuit() && !this.validateOrigin()) {
                Netty3CorsHandler.forbidden(ctx, this.request);
                return;
            }
        }
        super.messageReceived(ctx, e);
    }

    public static void setCorsResponseHeaders(HttpRequest request, HttpResponse resp, Netty3CorsConfig config) {
        String originHeaderVal;
        if (!config.isCorsSupportEnabled()) {
            return;
        }
        String originHeader = request.headers().get("Origin");
        if (!Strings.isNullOrEmpty(originHeader) && (originHeaderVal = config.isAnyOriginSupported() ? ANY_ORIGIN : (config.isOriginAllowed(originHeader) || Netty3CorsHandler.isSameOrigin(originHeader, request.headers().get("Host")) ? originHeader : null)) != null) {
            resp.headers().add("Access-Control-Allow-Origin", originHeaderVal);
        }
        if (config.isCredentialsAllowed()) {
            resp.headers().add("Access-Control-Allow-Credentials", "true");
        }
    }

    private void handlePreflight(ChannelHandlerContext ctx, HttpRequest request) {
        DefaultHttpResponse response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK);
        if (this.setOrigin(response)) {
            this.setAllowMethods(response);
            this.setAllowHeaders(response);
            this.setAllowCredentials(response);
            this.setMaxAge(response);
            this.setPreflightHeaders(response);
            ctx.getChannel().write(response).addListener(ChannelFutureListener.CLOSE);
        } else {
            Netty3CorsHandler.forbidden(ctx, request);
        }
    }

    private static void forbidden(ChannelHandlerContext ctx, HttpRequest request) {
        ctx.getChannel().write(new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.FORBIDDEN)).addListener(ChannelFutureListener.CLOSE);
    }

    private static boolean isSameOrigin(String origin, String host) {
        String originDomain;
        return !Strings.isNullOrEmpty(host) && host.equals(originDomain = SCHEME_PATTERN.matcher(origin).replaceFirst(""));
    }

    private void setPreflightHeaders(HttpResponse response) {
        response.headers().add(this.config.preflightResponseHeaders());
    }

    private boolean setOrigin(HttpResponse response) {
        String origin = this.request.headers().get("Origin");
        if (!Strings.isNullOrEmpty(origin)) {
            if ("null".equals(origin) && this.config.isNullOriginAllowed()) {
                Netty3CorsHandler.setAnyOrigin(response);
                return true;
            }
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(response);
                    Netty3CorsHandler.setVaryHeader(response);
                } else {
                    Netty3CorsHandler.setAnyOrigin(response);
                }
                return true;
            }
            if (this.config.isOriginAllowed(origin)) {
                Netty3CorsHandler.setOrigin(response, origin);
                Netty3CorsHandler.setVaryHeader(response);
                return true;
            }
        }
        return false;
    }

    private boolean validateOrigin() {
        if (this.config.isAnyOriginSupported()) {
            return true;
        }
        String origin = this.request.headers().get("Origin");
        if (Strings.isNullOrEmpty(origin)) {
            return true;
        }
        if ("null".equals(origin) && this.config.isNullOriginAllowed()) {
            return true;
        }
        if (Netty3CorsHandler.isSameOrigin(origin, this.request.headers().get("Host"))) {
            return true;
        }
        return this.config.isOriginAllowed(origin);
    }

    private void echoRequestOrigin(HttpResponse response) {
        Netty3CorsHandler.setOrigin(response, this.request.headers().get("Origin"));
    }

    private static void setVaryHeader(HttpResponse response) {
        response.headers().set("Vary", "Origin");
    }

    private static void setAnyOrigin(HttpResponse response) {
        Netty3CorsHandler.setOrigin(response, ANY_ORIGIN);
    }

    private static void setOrigin(HttpResponse response, String origin) {
        response.headers().set("Access-Control-Allow-Origin", origin);
    }

    private void setAllowCredentials(HttpResponse response) {
        if (this.config.isCredentialsAllowed() && !response.headers().get("Access-Control-Allow-Origin").equals(ANY_ORIGIN)) {
            response.headers().set("Access-Control-Allow-Credentials", "true");
        }
    }

    private static boolean isPreflightRequest(HttpRequest request) {
        HttpHeaders headers = request.headers();
        return request.getMethod().equals(HttpMethod.OPTIONS) && headers.contains("Origin") && headers.contains("Access-Control-Request-Method");
    }

    private void setAllowMethods(HttpResponse response) {
        response.headers().set("Access-Control-Allow-Methods", this.config.allowedRequestMethods().stream().map(m -> m.getName().trim()).collect(Collectors.toList()));
    }

    private void setAllowHeaders(HttpResponse response) {
        response.headers().set("Access-Control-Allow-Headers", this.config.allowedRequestHeaders());
    }

    private void setMaxAge(HttpResponse response) {
        response.headers().set("Access-Control-Max-Age", this.config.maxAge());
    }
}

