/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocValuesTermsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryShardContext;

public class ParentFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_parent";
    public static final String CONTENT_TYPE = "_parent";
    private final String parentType;
    private final KeywordFieldMapper parentJoinField;

    static KeywordFieldMapper createParentJoinFieldMapper(String docType, Mapper.BuilderContext context) {
        KeywordFieldMapper.Builder parentJoinField = new KeywordFieldMapper.Builder(ParentFieldMapper.joinField(docType));
        parentJoinField.indexOptions(IndexOptions.NONE);
        parentJoinField.docValues(true);
        parentJoinField.fieldType().setDocValuesType(DocValuesType.SORTED);
        return parentJoinField.build(context);
    }

    private ParentFieldMapper(KeywordFieldMapper parentJoinField, MappedFieldType childJoinFieldType, String parentType, Settings indexSettings) {
        super("_parent", childJoinFieldType, Defaults.FIELD_TYPE, indexSettings);
        this.parentType = parentType;
        this.parentJoinField = parentJoinField;
    }

    public MappedFieldType getParentJoinFieldType() {
        return this.parentJoinField.fieldType();
    }

    public String type() {
        return this.parentType;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        this.parse(context);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        boolean parent = context.docMapper().isParent(context.sourceToParse().type());
        if (parent) {
            fields.add(new SortedDocValuesField(this.parentJoinField.fieldType().name(), new BytesRef(context.sourceToParse().id())));
        }
        if (!this.active()) {
            return;
        }
        if (context.parser().currentName() != null && context.parser().currentName().equals("_parent")) {
            String parentId = context.parser().text();
            context.sourceToParse().parent(parentId);
            fields.add(new SortedDocValuesField(this.fieldType.name(), new BytesRef(parentId)));
        } else {
            String parsedParentId = context.doc().get("_parent");
            if (context.sourceToParse().parent() != null) {
                String parentId = context.sourceToParse().parent();
                if (parsedParentId == null) {
                    if (parentId == null) {
                        throw new MapperParsingException("No parent id provided, not within the document, and not externally");
                    }
                    fields.add(new SortedDocValuesField(this.fieldType.name(), new BytesRef(parentId)));
                } else if (parentId != null && !parsedParentId.equals(Uid.createUid(this.parentType, parentId))) {
                    throw new MapperParsingException("Parent id mismatch, document value is [" + Uid.createUid(parsedParentId).id() + "], while external value is [" + parentId + "]");
                }
            }
        }
    }

    public static String joinField(String parentType) {
        return "_parent#" + parentType;
    }

    @Override
    protected String contentType() {
        return "_parent";
    }

    @Override
    public Iterator<Mapper> iterator() {
        return Collections.singleton(this.parentJoinField).iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.active()) {
            return builder;
        }
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        builder.startObject("_parent");
        builder.field("type", this.parentType);
        if (includeDefaults || !this.fieldType().eagerGlobalOrdinals()) {
            builder.field("eager_global_ordinals", this.fieldType().eagerGlobalOrdinals());
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        ParentFieldMapper fieldMergeWith = (ParentFieldMapper)mergeWith;
        ParentFieldType currentFieldType = (ParentFieldType)this.fieldType.clone();
        super.doMerge(mergeWith, updateAllTypes);
        if (fieldMergeWith.parentType != null && !Objects.equals(this.parentType, fieldMergeWith.parentType)) {
            throw new IllegalArgumentException("The _parent field's type option can't be changed: [" + this.parentType + "]->[" + fieldMergeWith.parentType + "]");
        }
        if (this.active()) {
            this.fieldType = currentFieldType;
        }
    }

    public boolean active() {
        return this.parentType != null;
    }

    static final class ParentFieldType
    extends MappedFieldType {
        final String documentType;

        ParentFieldType() {
            this.documentType = null;
            this.setEagerGlobalOrdinals(true);
        }

        ParentFieldType(ParentFieldType ref, String documentType) {
            super(ref);
            this.documentType = documentType;
        }

        private ParentFieldType(ParentFieldType ref) {
            super(ref);
            this.documentType = ref.documentType;
        }

        @Override
        public MappedFieldType clone() {
            return new ParentFieldType(this);
        }

        @Override
        public String typeName() {
            return "_parent";
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            return this.termsQuery((List)Collections.singletonList(value), context);
        }

        public Query termsQuery(List values, @Nullable QueryShardContext context) {
            BytesRef[] ids = new BytesRef[values.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = BytesRefs.toBytesRef(values.get(i));
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            query.add(new DocValuesTermsQuery(this.name(), ids), BooleanClause.Occur.MUST);
            query.add(new TermQuery(new Term("_type", this.documentType)), BooleanClause.Occur.FILTER);
            return query.build();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            return new DocValuesIndexFieldData.Builder();
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        private static final ParseField FIELDDATA = new ParseField("fielddata", new String[0]).withAllDeprecated("eager_global_ordinals");

        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.type());
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("type")) {
                    builder.type(fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if (FIELDDATA.match(fieldName)) {
                    Map<String, String> fieldDataSettings = SettingsLoader.Helper.loadNestedFromMap(XContentMapValues.nodeMapValue(fieldNode, "fielddata"));
                    if (fieldDataSettings.containsKey("loading")) {
                        builder.eagerGlobalOrdinals("eager_global_ordinals".equals(fieldDataSettings.get("loading")));
                    }
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("eager_global_ordinals")) continue;
                builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(fieldNode));
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            String typeName = context.type();
            KeywordFieldMapper parentJoinField = ParentFieldMapper.createParentJoinFieldMapper(typeName, new Mapper.BuilderContext(indexSettings, new ContentPath(0)));
            ParentFieldType childJoinFieldType = new ParentFieldType(Defaults.FIELD_TYPE, typeName);
            childJoinFieldType.setName("_parent");
            return new ParentFieldMapper(parentJoinField, childJoinFieldType, null, indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, ParentFieldMapper> {
        private String parentType;
        private final String documentType;

        public Builder(String documentType) {
            super("_parent", new ParentFieldType(Defaults.FIELD_TYPE, documentType), Defaults.FIELD_TYPE);
            this.eagerGlobalOrdinals(true);
            this.documentType = documentType;
            this.builder = this;
        }

        public Builder type(String type) {
            this.parentType = type;
            return (Builder)this.builder;
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.fieldType().setEagerGlobalOrdinals(eagerGlobalOrdinals);
            return (Builder)this.builder;
        }

        @Override
        public ParentFieldMapper build(Mapper.BuilderContext context) {
            if (this.parentType == null) {
                throw new MapperParsingException("[_parent] field mapping must contain the [type] option");
            }
            this.name = ParentFieldMapper.joinField(this.parentType);
            this.setupFieldType(context);
            return new ParentFieldMapper(ParentFieldMapper.createParentJoinFieldMapper(this.documentType, context), this.fieldType, this.parentType, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_parent";
        public static final ParentFieldType FIELD_TYPE = new ParentFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setDocValuesType(DocValuesType.SORTED);
            FIELD_TYPE.setEagerGlobalOrdinals(false);
            FIELD_TYPE.freeze();
        }
    }
}

