/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.UidIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class UidFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_uid";
    public static final String CONTENT_TYPE = "_uid";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(UidFieldMapper.class));

    static MappedFieldType defaultFieldType(IndexSettings indexSettings) {
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        if (indexSettings.isSingleType()) {
            defaultFieldType.setIndexOptions(IndexOptions.NONE);
            defaultFieldType.setStored(false);
        } else {
            defaultFieldType.setIndexOptions(IndexOptions.DOCS);
            defaultFieldType.setStored(true);
        }
        return defaultFieldType;
    }

    private UidFieldMapper(IndexSettings indexSettings, MappedFieldType existing) {
        this(existing == null ? UidFieldMapper.defaultFieldType(indexSettings) : existing, indexSettings);
    }

    private UidFieldMapper(MappedFieldType fieldType, IndexSettings indexSettings) {
        super("_uid", fieldType, UidFieldMapper.defaultFieldType(indexSettings), indexSettings.getSettings());
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field uid = new Field("_uid", Uid.createUid(context.sourceToParse().type(), context.sourceToParse().id()), (FieldType)this.fieldType);
            fields.add(uid);
        }
    }

    @Override
    protected String contentType() {
        return "_uid";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class UidFieldType
    extends TermBasedFieldType {
        UidFieldType() {
        }

        protected UidFieldType(UidFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new UidFieldType(this);
        }

        @Override
        public String typeName() {
            return "_uid";
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            if (this.indexOptions() == IndexOptions.NONE) {
                DEPRECATION_LOGGER.deprecated("Fielddata access on the _uid field is deprecated, use _id instead", new Object[0]);
                return new IndexFieldData.Builder(){

                    @Override
                    public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
                        MappedFieldType idFieldType = mapperService.fullName("_id");
                        IndexOrdinalsFieldData idFieldData = (IndexOrdinalsFieldData)idFieldType.fielddataBuilder().build(indexSettings, idFieldType, cache, breakerService, mapperService);
                        String type = mapperService.types().iterator().next();
                        return new UidIndexFieldData(indexSettings.getIndex(), type, idFieldData);
                    }
                };
            }
            return new PagedBytesIndexFieldData.Builder(TextFieldMapper.Defaults.FIELDDATA_MIN_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MAX_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MIN_SEGMENT_SIZE);
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
            if (this.indexOptions() != IndexOptions.NONE) {
                return super.termsQuery(values, context);
            }
            Collection<String> indexTypes = context.getMapperService().types();
            if (indexTypes.isEmpty()) {
                return new MatchNoDocsQuery("No types");
            }
            assert (indexTypes.size() == 1);
            BytesRef indexType = this.indexedValueForSearch(indexTypes.iterator().next());
            BytesRefBuilder prefixBuilder = new BytesRefBuilder();
            prefixBuilder.append(indexType);
            prefixBuilder.append((byte)35);
            BytesRef expectedPrefix = prefixBuilder.get();
            ArrayList<BytesRef> ids = new ArrayList<BytesRef>();
            for (Object uid : values) {
                BytesRef uidBytes = this.indexedValueForSearch(uid);
                if (!StringHelper.startsWith(uidBytes, expectedPrefix)) continue;
                BytesRef id = new BytesRef();
                id.bytes = uidBytes.bytes;
                id.offset = uidBytes.offset + expectedPrefix.length;
                id.length = uidBytes.length - expectedPrefix.length;
                ids.add(id);
            }
            return new TermInSetQuery("_id", ids);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_uid is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            IndexSettings indexSettings = context.mapperService().getIndexSettings();
            return new UidFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Defaults {
        public static final String NAME = "_uid";
        public static final MappedFieldType FIELD_TYPE = new UidFieldType();
        public static final MappedFieldType NESTED_FIELD_TYPE;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_uid");
            FIELD_TYPE.freeze();
            NESTED_FIELD_TYPE = FIELD_TYPE.clone();
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

