/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.fetch;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;

public final class ParentJoinFieldSubFetchPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        Map<String, SearchHitField> fields;
        if (context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        ParentJoinFieldMapper mapper = ParentJoinFieldMapper.getMapper(context.mapperService());
        if (mapper == null) {
            return;
        }
        String joinName = this.getSortedDocValue(mapper.name(), hitContext.reader(), hitContext.docId());
        if (joinName == null) {
            return;
        }
        ParentIdFieldMapper parentMapper = mapper.getParentIdFieldMapper(joinName, false);
        String parentId = null;
        if (parentMapper != null) {
            parentId = this.getSortedDocValue(parentMapper.name(), hitContext.reader(), hitContext.docId());
        }
        if ((fields = hitContext.hit().fieldsOrNull()) == null) {
            fields = new HashMap<String, SearchHitField>();
            hitContext.hit().fields(fields);
        }
        fields.put(mapper.name(), new SearchHitField(mapper.name(), Collections.singletonList(joinName)));
        if (parentId != null) {
            fields.put(parentMapper.name(), new SearchHitField(parentMapper.name(), Collections.singletonList(parentId)));
        }
    }

    private String getSortedDocValue(String field, LeafReader reader, int docId) {
        try {
            SortedDocValues docValues = reader.getSortedDocValues(field);
            if (docValues == null) {
                return null;
            }
            int ord = docValues.getOrd(docId);
            if (ord == -1) {
                return null;
            }
            BytesRef joinName = docValues.lookupOrd(ord);
            return joinName.utf8ToString();
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }
}

