/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

final class Netty3SizeHeaderFrameDecoder
extends FrameDecoder {
    Netty3SizeHeaderFrameDecoder() {
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        try {
            boolean continueProcessing = TcpTransport.validateMessageHeader(Netty3Utils.toBytesReference(buffer));
            buffer.skipBytes(6);
            return continueProcessing ? buffer : null;
        }
        catch (IllegalArgumentException ex) {
            throw new TooLongFrameException(ex.getMessage(), ex);
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }
}

