/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.util.Version;

public final class ThaiAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public ThaiAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public ThaiAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        ThaiTokenizer source = new ThaiTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        if (this.getVersion().onOrAfter(Version.LUCENE_5_4_0)) {
            result = new DecimalDigitFilter(result);
        }
        result = new StopFilter(result, this.stopwords);
        return new Analyzer.TokenStreamComponents(source, result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new LowerCaseFilter(in);
        result = new DecimalDigitFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = ThaiAnalyzer.loadStopwordSet(false, ThaiAnalyzer.class, ThaiAnalyzer.DEFAULT_STOPWORD_FILE, ThaiAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

