/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.SecondPassGroupingCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public class TermSecondPassGroupingCollector
extends SecondPassGroupingCollector<BytesRef> {
    private final String groupField;
    private final SentinelIntSet ordSet;
    private SortedDocValues index;

    public TermSecondPassGroupingCollector(String groupField, Collection<SearchGroup<BytesRef>> groups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        super(groups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
        this.groupField = groupField;
        this.ordSet = new SentinelIntSet(this.groupMap.size(), -2);
        this.groupDocs = new SecondPassGroupingCollector.SearchGroupDocs[this.ordSet.keys.length];
    }

    @Override
    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        super.doSetNextReader(readerContext);
        this.index = DocValues.getSorted(readerContext.reader(), this.groupField);
        this.ordSet.clear();
        for (SecondPassGroupingCollector.SearchGroupDocs group : this.groupMap.values()) {
            int ord;
            int n = ord = group.groupValue == null ? -1 : this.index.lookupTerm((BytesRef)group.groupValue);
            if (group.groupValue != null && ord < 0) continue;
            this.groupDocs[this.ordSet.put((int)ord)] = group;
        }
    }

    @Override
    protected SecondPassGroupingCollector.SearchGroupDocs<BytesRef> retrieveGroup(int doc) throws IOException {
        int slot = this.ordSet.find(this.index.getOrd(doc));
        if (slot >= 0) {
            return this.groupDocs[slot];
        }
        return null;
    }
}

