/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndicesService;

public class Gateway
extends AbstractComponent
implements ClusterStateApplier {
    private final ClusterService clusterService;
    private final GatewayMetaState metaState;
    private final TransportNodesListGatewayMetaState listGatewayMetaState;
    private final Supplier<Integer> minimumMasterNodesProvider;
    private final IndicesService indicesService;

    public Gateway(Settings settings, ClusterService clusterService, GatewayMetaState metaState, TransportNodesListGatewayMetaState listGatewayMetaState, Discovery discovery, IndicesService indicesService) {
        super(settings);
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.metaState = metaState;
        this.listGatewayMetaState = listGatewayMetaState;
        this.minimumMasterNodesProvider = discovery::getMinimumMasterNodes;
        clusterService.addLowPriorityApplier(this);
    }

    public void performStateRecovery(GatewayStateRecoveredListener listener) throws GatewayException {
        Object[] nodesIds = this.clusterService.state().nodes().getMasterNodes().keys().toArray(String.class);
        this.logger.trace("performing state recovery from {}", (Object)Arrays.toString(nodesIds));
        TransportNodesListGatewayMetaState.NodesGatewayMetaState nodesState = this.listGatewayMetaState.list((String[])nodesIds, null).actionGet();
        int requiredAllocation = Math.max(1, this.minimumMasterNodesProvider.get());
        if (nodesState.hasFailures()) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                this.logger.warn("failed to fetch state from node", (Throwable)failedNodeException);
            }
        }
        ObjectFloatHashMap<Index> indices = new ObjectFloatHashMap<Index>();
        MetaData electedGlobalState = null;
        int found = 0;
        for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
            if (nodeState.metaData() == null) continue;
            ++found;
            if (electedGlobalState == null) {
                electedGlobalState = nodeState.metaData();
            } else if (nodeState.metaData().version() > electedGlobalState.version()) {
                electedGlobalState = nodeState.metaData();
            }
            for (ObjectCursor<IndexMetaData> objectCursor : nodeState.metaData().indices().values()) {
                indices.addTo(((IndexMetaData)objectCursor.value).getIndex(), 1.0f);
            }
        }
        if (found < requiredAllocation) {
            listener.onFailure("found [" + found + "] metadata states, required [" + requiredAllocation + "]");
            return;
        }
        MetaData.Builder metaDataBuilder = MetaData.builder(electedGlobalState).removeAllIndices();
        assert (!indices.containsKey(null));
        Object[] keys = indices.keys;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            Index index = (Index)keys[i];
            IndexMetaData electedIndexMetaData = null;
            int indexMetaDataCount = 0;
            for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
                IndexMetaData indexMetaData;
                if (nodeState.metaData() == null || (indexMetaData = nodeState.metaData().index(index)) == null) continue;
                if (electedIndexMetaData == null) {
                    electedIndexMetaData = indexMetaData;
                } else if (indexMetaData.getVersion() > electedIndexMetaData.getVersion()) {
                    electedIndexMetaData = indexMetaData;
                }
                ++indexMetaDataCount;
            }
            if (electedIndexMetaData == null) continue;
            if (indexMetaDataCount < requiredAllocation) {
                this.logger.debug("[{}] found [{}], required [{}], not adding", (Object)index, (Object)indexMetaDataCount, (Object)requiredAllocation);
            }
            try {
                if (electedIndexMetaData.getState() == IndexMetaData.State.OPEN) {
                    this.indicesService.verifyIndexMetadata(electedIndexMetaData, electedIndexMetaData);
                }
            }
            catch (Exception e2) {
                Index electedIndex = electedIndexMetaData.getIndex();
                this.logger.warn(() -> new ParameterizedMessage("recovering index {} failed - recovering as closed", (Object)electedIndex), (Throwable)e2);
                electedIndexMetaData = IndexMetaData.builder(electedIndexMetaData).state(IndexMetaData.State.CLOSE).build();
            }
            metaDataBuilder.put(electedIndexMetaData, false);
        }
        ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
        metaDataBuilder.persistentSettings(clusterSettings.archiveUnknownOrInvalidSettings(metaDataBuilder.persistentSettings(), e -> this.logUnknownSetting("persistent", (Map.Entry<String, String>)e), (e, ex) -> this.logInvalidSetting("persistent", (Map.Entry<String, String>)e, (IllegalArgumentException)ex)));
        metaDataBuilder.transientSettings(clusterSettings.archiveUnknownOrInvalidSettings(metaDataBuilder.transientSettings(), e -> this.logUnknownSetting("transient", (Map.Entry<String, String>)e), (e, ex) -> this.logInvalidSetting("transient", (Map.Entry<String, String>)e, (IllegalArgumentException)ex)));
        ClusterState.Builder builder = ClusterState.builder(this.clusterService.getClusterName());
        builder.metaData(metaDataBuilder);
        listener.onSuccess(builder.build());
    }

    private void logUnknownSetting(String settingType, Map.Entry<String, String> e) {
        this.logger.warn("ignoring unknown {} setting: [{}] with value [{}]; archiving", (Object)settingType, (Object)e.getKey(), (Object)e.getValue());
    }

    private void logInvalidSetting(String settingType, Map.Entry<String, String> e, IllegalArgumentException ex) {
        this.logger.warn(() -> new ParameterizedMessage("ignoring invalid {} setting: [{}] with value [{}]; archiving", settingType, e.getKey(), e.getValue()), (Throwable)ex);
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.metaState.applyClusterState(event);
    }

    public static interface GatewayStateRecoveredListener {
        public void onSuccess(ClusterState var1);

        public void onFailure(String var1);
    }
}

