/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractRandomAccessOrds;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.elasticsearch.search.MultiValueMode;

public final class UidIndexFieldData
implements IndexOrdinalsFieldData {
    private final Index index;
    private final String type;
    private final BytesRef prefix;
    private final IndexOrdinalsFieldData idFieldData;

    public UidIndexFieldData(Index index, String type, IndexOrdinalsFieldData idFieldData) {
        this.index = index;
        this.type = type;
        BytesRefBuilder prefix = new BytesRefBuilder();
        prefix.append(new BytesRef(type));
        prefix.append((byte)35);
        this.prefix = prefix.toBytesRef();
        this.idFieldData = idFieldData;
    }

    @Override
    public Index index() {
        return this.index;
    }

    @Override
    public String getFieldName() {
        return "_uid";
    }

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), source, reverse);
    }

    @Override
    public AtomicOrdinalsFieldData load(LeafReaderContext context) {
        return new UidAtomicFieldData(this.prefix, (AtomicOrdinalsFieldData)this.idFieldData.load(context));
    }

    @Override
    public AtomicOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        return new UidAtomicFieldData(this.prefix, (AtomicOrdinalsFieldData)this.idFieldData.loadDirect(context));
    }

    @Override
    public void clear() {
        this.idFieldData.clear();
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        return new UidIndexFieldData(this.index, this.type, this.idFieldData.loadGlobal(indexReader));
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return new UidIndexFieldData(this.index, this.type, this.idFieldData.localGlobalDirect(indexReader));
    }

    @Override
    public MultiDocValues.OrdinalMap getOrdinalMap() {
        return this.idFieldData.getOrdinalMap();
    }

    static final class UidAtomicFieldData
    implements AtomicOrdinalsFieldData {
        private final BytesRef prefix;
        private final AtomicOrdinalsFieldData idFieldData;

        UidAtomicFieldData(BytesRef prefix, AtomicOrdinalsFieldData idFieldData) {
            this.prefix = prefix;
            this.idFieldData = idFieldData;
        }

        @Override
        public ScriptDocValues<?> getScriptValues() {
            return AbstractAtomicOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION.apply(this.getOrdinalsValues());
        }

        @Override
        public SortedBinaryDocValues getBytesValues() {
            return FieldData.toString(this.getOrdinalsValues());
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public void close() {
            this.idFieldData.close();
        }

        @Override
        public RandomAccessOrds getOrdinalsValues() {
            final RandomAccessOrds idValues = this.idFieldData.getOrdinalsValues();
            return new AbstractRandomAccessOrds(){
                private final BytesRefBuilder scratch = new BytesRefBuilder();

                @Override
                public BytesRef lookupOrd(long ord) {
                    this.scratch.setLength(0);
                    this.scratch.append(prefix);
                    this.scratch.append(idValues.lookupOrd(ord));
                    return this.scratch.get();
                }

                @Override
                public long getValueCount() {
                    return idValues.getValueCount();
                }

                @Override
                protected void doSetDocument(int docID) {
                    idValues.setDocument(docID);
                }

                @Override
                public long ordAt(int index) {
                    return idValues.ordAt(index);
                }

                @Override
                public int cardinality() {
                    return idValues.cardinality();
                }
            };
        }
    }
}

