/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class FieldMapper
extends Mapper
implements Cloneable {
    public static final Setting<Boolean> IGNORE_MALFORMED_SETTING = Setting.boolSetting("index.mapping.ignore_malformed", false, Setting.Property.IndexScope);
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", false, Setting.Property.IndexScope);
    protected final Version indexCreatedVersion;
    protected MappedFieldType fieldType;
    protected final MappedFieldType defaultFieldType;
    protected MultiFields multiFields;
    protected CopyTo copyTo;

    protected FieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, MultiFields multiFields, CopyTo copyTo) {
        super(simpleName);
        assert (indexSettings != null);
        this.indexCreatedVersion = Version.indexCreated(indexSettings);
        if (this.indexCreatedVersion.onOrAfter(Version.V_5_0_0_beta1) && simpleName.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty string");
        }
        fieldType.freeze();
        this.fieldType = fieldType;
        defaultFieldType.freeze();
        this.defaultFieldType = defaultFieldType;
        this.multiFields = multiFields;
        this.copyTo = copyTo;
    }

    @Override
    public String name() {
        return this.fieldType().name();
    }

    public MappedFieldType fieldType() {
        return this.fieldType;
    }

    public CopyTo copyTo() {
        return this.copyTo;
    }

    public Mapper parse(ParseContext context) throws IOException {
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>(2);
        try {
            this.parseCreateField(context, fields);
            for (IndexableField field : fields) {
                if (!this.customBoost() && field.fieldType().indexOptions() != IndexOptions.NONE && this.indexCreatedVersion.before(Version.V_5_0_0_alpha1)) {
                    ((Field)field).setBoost(this.fieldType().boost());
                }
                context.doc().add(field);
            }
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse [" + this.fieldType().name() + "]", e);
        }
        this.multiFields.parse(this, context);
        return null;
    }

    protected abstract void parseCreateField(ParseContext var1, List<IndexableField> var2) throws IOException;

    protected boolean customBoost() {
        return false;
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.multiFields.iterator();
    }

    protected FieldMapper clone() {
        try {
            return (FieldMapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public FieldMapper merge(Mapper mergeWith, boolean updateAllTypes) {
        FieldMapper merged = this.clone();
        merged.doMerge(mergeWith, updateAllTypes);
        return merged;
    }

    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        if (!this.getClass().equals(mergeWith.getClass())) {
            String mergedType = mergeWith.getClass().getSimpleName();
            if (mergeWith instanceof FieldMapper) {
                mergedType = ((FieldMapper)mergeWith).contentType();
            }
            throw new IllegalArgumentException("mapper [" + this.fieldType().name() + "] of different type, current_type [" + this.contentType() + "], merged_type [" + mergedType + "]");
        }
        FieldMapper fieldMergeWith = (FieldMapper)mergeWith;
        this.multiFields = this.multiFields.merge(fieldMergeWith.multiFields);
        this.fieldType = fieldMergeWith.fieldType;
        this.copyTo = fieldMergeWith.copyTo;
    }

    @Override
    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        MappedFieldType newFieldType = fullNameToFieldType.get(this.fieldType.name());
        if (newFieldType == null) {
            return this;
        }
        if (this.fieldType.getClass() != newFieldType.getClass()) {
            throw new IllegalStateException("Mixing up field types: " + this.fieldType.getClass() + " != " + newFieldType.getClass() + " on field " + this.fieldType.name());
        }
        MultiFields updatedMultiFields = this.multiFields.updateFieldType(fullNameToFieldType);
        if (this.fieldType == newFieldType && this.multiFields == updatedMultiFields) {
            return this;
        }
        FieldMapper updated = this.clone();
        updated.fieldType = newFieldType;
        updated.multiFields = updatedMultiFields;
        return updated;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults, params);
        return builder.endObject();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        boolean defaultIndexed;
        builder.field("type", this.contentType());
        if (includeDefaults || this.fieldType().boost() != 1.0f) {
            builder.field("boost", this.fieldType().boost());
        }
        boolean indexed = this.fieldType().indexOptions() != IndexOptions.NONE;
        boolean bl = defaultIndexed = this.defaultFieldType.indexOptions() != IndexOptions.NONE;
        if (includeDefaults || indexed != defaultIndexed || this.fieldType().tokenized() != this.defaultFieldType.tokenized()) {
            builder.field("index", this.indexTokenizeOption(indexed, this.fieldType().tokenized()));
        }
        if (includeDefaults || this.fieldType().stored() != this.defaultFieldType.stored()) {
            builder.field("store", this.fieldType().stored());
        }
        this.doXContentDocValues(builder, includeDefaults);
        if (includeDefaults || this.fieldType().storeTermVectors() != this.defaultFieldType.storeTermVectors()) {
            builder.field("term_vector", FieldMapper.termVectorOptionsToString(this.fieldType()));
        }
        if (includeDefaults || this.fieldType().omitNorms() != this.defaultFieldType.omitNorms()) {
            builder.field("norms", !this.fieldType().omitNorms());
        }
        if (indexed && (includeDefaults || this.fieldType().indexOptions() != this.defaultFieldType.indexOptions())) {
            builder.field("index_options", FieldMapper.indexOptionToString(this.fieldType().indexOptions()));
        }
        if (includeDefaults || this.fieldType().eagerGlobalOrdinals() != this.defaultFieldType.eagerGlobalOrdinals()) {
            builder.field("eager_global_ordinals", this.fieldType().eagerGlobalOrdinals());
        }
        if (this.fieldType().similarity() != null) {
            builder.field("similarity", this.fieldType().similarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "BM25");
        }
        this.multiFields.toXContent(builder, params);
        if (this.copyTo != null) {
            this.copyTo.toXContent(builder, params);
        }
    }

    protected final void doXContentAnalyzers(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (!this.fieldType.tokenized()) {
            return;
        }
        if (this.fieldType().indexAnalyzer() == null) {
            if (includeDefaults) {
                builder.field("analyzer", "default");
            }
        } else {
            boolean hasDifferentSearchQuoteAnalyzer;
            boolean hasDefaultIndexAnalyzer = this.fieldType().indexAnalyzer().name().equals("default");
            boolean hasDifferentSearchAnalyzer = !this.fieldType().searchAnalyzer().name().equals(this.fieldType().indexAnalyzer().name());
            boolean bl = hasDifferentSearchQuoteAnalyzer = !this.fieldType().searchAnalyzer().name().equals(this.fieldType().searchQuoteAnalyzer().name());
            if (includeDefaults || !hasDefaultIndexAnalyzer || hasDifferentSearchAnalyzer || hasDifferentSearchQuoteAnalyzer) {
                builder.field("analyzer", this.fieldType().indexAnalyzer().name());
                if (includeDefaults || hasDifferentSearchAnalyzer || hasDifferentSearchQuoteAnalyzer) {
                    builder.field("search_analyzer", this.fieldType().searchAnalyzer().name());
                    if (includeDefaults || hasDifferentSearchQuoteAnalyzer) {
                        builder.field("search_quote_analyzer", this.fieldType().searchQuoteAnalyzer().name());
                    }
                }
            }
        }
    }

    protected void doXContentDocValues(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (includeDefaults || this.defaultFieldType.hasDocValues() != this.fieldType().hasDocValues()) {
            builder.field("doc_values", this.fieldType().hasDocValues());
        }
    }

    protected static String indexOptionToString(IndexOptions indexOption) {
        switch (indexOption) {
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return "offsets";
            }
            case DOCS_AND_FREQS: {
                return "freqs";
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return "positions";
            }
            case DOCS: {
                return "docs";
            }
        }
        throw new IllegalArgumentException("Unknown IndexOptions [" + (Object)((Object)indexOption) + "]");
    }

    public static String termVectorOptionsToString(FieldType fieldType) {
        if (!fieldType.storeTermVectors()) {
            return "no";
        }
        if (!fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "yes";
        }
        if (fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPositions()) {
            return "with_offsets";
        }
        StringBuilder builder = new StringBuilder("with");
        if (fieldType.storeTermVectorPositions()) {
            builder.append("_positions");
        }
        if (fieldType.storeTermVectorOffsets()) {
            builder.append("_offsets");
        }
        if (fieldType.storeTermVectorPayloads()) {
            builder.append("_payloads");
        }
        return builder.toString();
    }

    protected Object indexTokenizeOption(boolean indexed, boolean tokenized) {
        return indexed;
    }

    protected abstract String contentType();

    public static class CopyTo {
        private final List<String> copyToFields;

        private CopyTo(List<String> copyToFields) {
            this.copyToFields = copyToFields;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.copyToFields.isEmpty()) {
                builder.startArray("copy_to");
                for (String field : this.copyToFields) {
                    builder.value(field);
                }
                builder.endArray();
            }
            return builder;
        }

        public List<String> copyToFields() {
            return this.copyToFields;
        }

        public static class Builder {
            private final List<String> copyToBuilders = new ArrayList<String>();

            public Builder add(String field) {
                this.copyToBuilders.add(field);
                return this;
            }

            public CopyTo build() {
                return new CopyTo(Collections.unmodifiableList(this.copyToBuilders));
            }
        }
    }

    public static class MultiFields {
        private final ImmutableOpenMap<String, FieldMapper> mappers;

        public static MultiFields empty() {
            return new MultiFields(ImmutableOpenMap.of());
        }

        private MultiFields(ImmutableOpenMap<String, FieldMapper> mappers) {
            ImmutableOpenMap.Builder builder = new ImmutableOpenMap.Builder();
            for (ObjectObjectCursor<String, FieldMapper> objectObjectCursor : mappers) {
                builder.put(objectObjectCursor.key, objectObjectCursor.value);
            }
            this.mappers = builder.build();
        }

        public void parse(FieldMapper mainField, ParseContext context) throws IOException {
            if (this.mappers.isEmpty()) {
                return;
            }
            context = context.createMultiFieldContext();
            context.path().add(mainField.simpleName());
            for (ObjectCursor<FieldMapper> objectCursor : this.mappers.values()) {
                ((FieldMapper)objectCursor.value).parse(context);
            }
            context.path().remove();
        }

        public MultiFields merge(MultiFields mergeWith) {
            ImmutableOpenMap.Builder<String, FieldMapper> newMappersBuilder = ImmutableOpenMap.builder(this.mappers);
            for (ObjectCursor<FieldMapper> objectCursor : mergeWith.mappers.values()) {
                FieldMapper mergeWithMapper = (FieldMapper)objectCursor.value;
                FieldMapper mergeIntoMapper = this.mappers.get(mergeWithMapper.simpleName());
                if (mergeIntoMapper == null) {
                    newMappersBuilder.put(mergeWithMapper.simpleName(), mergeWithMapper);
                    continue;
                }
                FieldMapper merged = mergeIntoMapper.merge(mergeWithMapper, false);
                newMappersBuilder.put(merged.simpleName(), merged);
            }
            ImmutableOpenMap<String, FieldMapper> mappers = newMappersBuilder.build();
            return new MultiFields(mappers);
        }

        public MultiFields updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
            ImmutableOpenMap.Builder<String, FieldMapper> newMappersBuilder = null;
            for (ObjectCursor<FieldMapper> objectCursor : this.mappers.values()) {
                Mapper updated = ((FieldMapper)objectCursor.value).updateFieldType((Map)fullNameToFieldType);
                if (updated == objectCursor.value) continue;
                if (newMappersBuilder == null) {
                    newMappersBuilder = ImmutableOpenMap.builder(this.mappers);
                }
                newMappersBuilder.put(updated.simpleName(), (FieldMapper)updated);
            }
            if (newMappersBuilder == null) {
                return this;
            }
            ImmutableOpenMap<String, FieldMapper> mappers = newMappersBuilder.build();
            return new MultiFields(mappers);
        }

        public Iterator<Mapper> iterator() {
            return StreamSupport.stream(this.mappers.values().spliterator(), false).map(p -> (Mapper)p.value).iterator();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.mappers.isEmpty()) {
                Mapper[] sortedMappers = this.mappers.values().toArray(Mapper.class);
                Arrays.sort(sortedMappers, new Comparator<Mapper>(){

                    @Override
                    public int compare(Mapper o1, Mapper o2) {
                        return o1.name().compareTo(o2.name());
                    }
                });
                builder.startObject("fields");
                for (Mapper mapper : sortedMappers) {
                    mapper.toXContent(builder, params);
                }
                builder.endObject();
            }
            return builder;
        }

        public static class Builder {
            private final ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = ImmutableOpenMap.builder();

            public Builder add(Mapper.Builder builder) {
                this.mapperBuilders.put(builder.name(), builder);
                return this;
            }

            public MultiFields build(org.elasticsearch.index.mapper.FieldMapper$Builder mainFieldBuilder, Mapper.BuilderContext context) {
                if (this.mapperBuilders.isEmpty()) {
                    return MultiFields.empty();
                }
                context.path().add(mainFieldBuilder.name());
                ImmutableOpenMap.Builder<String, Mapper.Builder> mapperBuilders = this.mapperBuilders;
                for (ObjectObjectCursor<String, Mapper.Builder> objectObjectCursor : this.mapperBuilders) {
                    String key = (String)objectObjectCursor.key;
                    Mapper.Builder value = (Mapper.Builder)objectObjectCursor.value;
                    Object mapper = value.build(context);
                    assert (mapper instanceof FieldMapper);
                    mapperBuilders.put(key, (Mapper.Builder)mapper);
                }
                context.path().remove();
                ImmutableOpenMap.Builder mappers = mapperBuilders.cast();
                return new MultiFields(mappers.build());
            }
        }
    }

    public static abstract class Builder<T extends Builder, Y extends FieldMapper>
    extends Mapper.Builder<T, Y> {
        protected final MappedFieldType fieldType;
        protected final MappedFieldType defaultFieldType;
        private final IndexOptions defaultOptions;
        protected boolean omitNormsSet = false;
        protected Boolean includeInAll;
        protected boolean indexOptionsSet = false;
        protected boolean docValuesSet = false;
        protected final MultiFields.Builder multiFieldsBuilder;
        protected CopyTo copyTo;

        protected Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType) {
            super(name);
            this.fieldType = fieldType.clone();
            this.defaultFieldType = defaultFieldType.clone();
            this.defaultOptions = fieldType.indexOptions();
            this.docValuesSet = fieldType.hasDocValues();
            this.multiFieldsBuilder = new MultiFields.Builder();
        }

        public MappedFieldType fieldType() {
            return this.fieldType;
        }

        public T index(boolean index) {
            if (index) {
                if (this.fieldType.indexOptions() == IndexOptions.NONE) {
                    IndexOptions options = this.getDefaultIndexOption();
                    if (options == IndexOptions.NONE) {
                        throw new IllegalArgumentException("mapper [" + this.name + "] has different [index] values from other types of the same index");
                    }
                    this.fieldType.setIndexOptions(options);
                }
            } else {
                this.fieldType.setIndexOptions(IndexOptions.NONE);
            }
            return (T)((Builder)this.builder);
        }

        protected IndexOptions getDefaultIndexOption() {
            return this.defaultOptions;
        }

        public T store(boolean store) {
            this.fieldType.setStored(store);
            return (T)((Builder)this.builder);
        }

        public T docValues(boolean docValues) {
            this.fieldType.setHasDocValues(docValues);
            this.docValuesSet = true;
            return (T)((Builder)this.builder);
        }

        public T storeTermVectors(boolean termVectors) {
            if (termVectors != this.fieldType.storeTermVectors()) {
                this.fieldType.setStoreTermVectors(termVectors);
            }
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorOffsets(boolean termVectorOffsets) {
            if (termVectorOffsets) {
                this.fieldType.setStoreTermVectors(termVectorOffsets);
            }
            this.fieldType.setStoreTermVectorOffsets(termVectorOffsets);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPositions(boolean termVectorPositions) {
            if (termVectorPositions) {
                this.fieldType.setStoreTermVectors(termVectorPositions);
            }
            this.fieldType.setStoreTermVectorPositions(termVectorPositions);
            return (T)((Builder)this.builder);
        }

        public T storeTermVectorPayloads(boolean termVectorPayloads) {
            if (termVectorPayloads) {
                this.fieldType.setStoreTermVectors(termVectorPayloads);
            }
            this.fieldType.setStoreTermVectorPayloads(termVectorPayloads);
            return (T)((Builder)this.builder);
        }

        public T tokenized(boolean tokenized) {
            this.fieldType.setTokenized(tokenized);
            return (T)((Builder)this.builder);
        }

        public T boost(float boost) {
            this.fieldType.setBoost(boost);
            return (T)((Builder)this.builder);
        }

        public T omitNorms(boolean omitNorms) {
            this.fieldType.setOmitNorms(omitNorms);
            this.omitNormsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexOptions(IndexOptions indexOptions) {
            this.fieldType.setIndexOptions(indexOptions);
            this.indexOptionsSet = true;
            return (T)((Builder)this.builder);
        }

        public T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.fieldType.setIndexAnalyzer(indexAnalyzer);
            return (T)((Builder)this.builder);
        }

        public T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.fieldType.setSearchAnalyzer(searchAnalyzer);
            return (T)((Builder)this.builder);
        }

        public T searchQuoteAnalyzer(NamedAnalyzer searchQuoteAnalyzer) {
            this.fieldType.setSearchQuoteAnalyzer(searchQuoteAnalyzer);
            return (T)((Builder)this.builder);
        }

        public T includeInAll(Boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        public T similarity(SimilarityProvider similarity) {
            this.fieldType.setSimilarity(similarity);
            return (T)((Builder)this.builder);
        }

        public Builder nullValue(Object nullValue) {
            this.fieldType.setNullValue(nullValue);
            return this;
        }

        public T addMultiField(Mapper.Builder mapperBuilder) {
            this.multiFieldsBuilder.add(mapperBuilder);
            return (T)((Builder)this.builder);
        }

        public T copyTo(CopyTo copyTo) {
            this.copyTo = copyTo;
            return (T)((Builder)this.builder);
        }

        protected String buildFullName(Mapper.BuilderContext context) {
            return context.path().pathAsText(this.name);
        }

        protected boolean defaultDocValues(Version indexCreated) {
            if (indexCreated.onOrAfter(Version.V_5_0_0_alpha1)) {
                return !this.fieldType.tokenized();
            }
            return !this.fieldType.tokenized() && this.fieldType.indexOptions() != IndexOptions.NONE;
        }

        protected void setupFieldType(Mapper.BuilderContext context) {
            this.fieldType.setName(this.buildFullName(context));
            if (context.indexCreatedVersion().before(Version.V_5_0_0_alpha1)) {
                this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.fieldType.boost() == 1.0f);
            }
            if (this.fieldType.indexAnalyzer() == null && !this.fieldType.tokenized() && this.fieldType.indexOptions() != IndexOptions.NONE) {
                this.fieldType.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
                this.fieldType.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            }
            boolean defaultDocValues = this.defaultDocValues(context.indexCreatedVersion());
            this.defaultFieldType.setHasDocValues(defaultDocValues);
            if (!this.docValuesSet) {
                this.fieldType.setHasDocValues(defaultDocValues);
            }
        }
    }
}

