/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;

final class PercolateQuery
extends Query
implements Accountable {
    public static final float MATCH_COST = 1000.0f;
    private final String documentType;
    private final QueryStore queryStore;
    private final BytesReference documentSource;
    private final Query candidateMatchesQuery;
    private final Query verifiedMatchesQuery;
    private final IndexSearcher percolatorIndexSearcher;

    PercolateQuery(String documentType, QueryStore queryStore, BytesReference documentSource, Query candidateMatchesQuery, IndexSearcher percolatorIndexSearcher, Query verifiedMatchesQuery) {
        this.documentType = Objects.requireNonNull(documentType);
        this.documentSource = Objects.requireNonNull(documentSource);
        this.candidateMatchesQuery = Objects.requireNonNull(candidateMatchesQuery);
        this.queryStore = Objects.requireNonNull(queryStore);
        this.percolatorIndexSearcher = Objects.requireNonNull(percolatorIndexSearcher);
        this.verifiedMatchesQuery = Objects.requireNonNull(verifiedMatchesQuery);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.candidateMatchesQuery.rewrite(reader);
        if (rewritten != this.candidateMatchesQuery) {
            return new PercolateQuery(this.documentType, this.queryStore, this.documentSource, rewritten, this.percolatorIndexSearcher, this.verifiedMatchesQuery);
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final boolean needsScores) throws IOException {
        final Weight verifiedMatchesWeight = this.verifiedMatchesQuery.createWeight(searcher, false);
        final Weight candidateMatchesWeight = this.candidateMatchesQuery.createWeight(searcher, false);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> set) {
            }

            @Override
            public Explanation explain(LeafReaderContext leafReaderContext, int docId) throws IOException {
                TwoPhaseIterator twoPhaseIterator;
                int result;
                Scorer scorer = this.scorer(leafReaderContext);
                if (scorer != null && (result = (twoPhaseIterator = scorer.twoPhaseIterator()).approximation().advance(docId)) == docId && twoPhaseIterator.matches()) {
                    if (needsScores) {
                        CheckedFunction<Integer, Query, IOException> percolatorQueries = PercolateQuery.this.queryStore.getQueries(leafReaderContext);
                        Query query = percolatorQueries.apply(docId);
                        Explanation detail = PercolateQuery.this.percolatorIndexSearcher.explain(query, 0);
                        return Explanation.match(scorer.score(), "PercolateQuery", detail);
                    }
                    return Explanation.match(scorer.score(), "PercolateQuery", new Explanation[0]);
                }
                return Explanation.noMatch("PercolateQuery", new Explanation[0]);
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return candidateMatchesWeight.getValueForNormalization();
            }

            @Override
            public void normalize(float v, float v1) {
                candidateMatchesWeight.normalize(v, v1);
            }

            @Override
            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                Scorer approximation = candidateMatchesWeight.scorer(leafReaderContext);
                if (approximation == null) {
                    return null;
                }
                CheckedFunction<Integer, Query, IOException> queries = PercolateQuery.this.queryStore.getQueries(leafReaderContext);
                if (needsScores) {
                    return new BaseScorer(this, approximation, queries, PercolateQuery.this.percolatorIndexSearcher){
                        float score;

                        @Override
                        boolean matchDocId(int docId) throws IOException {
                            Query query = (Query)this.percolatorQueries.apply(docId);
                            if (query != null) {
                                TopDocs topDocs = this.percolatorIndexSearcher.search(query, 1);
                                if (topDocs.totalHits > 0) {
                                    this.score = topDocs.scoreDocs[0].score;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }

                        @Override
                        public float score() throws IOException {
                            return this.score;
                        }
                    };
                }
                ScorerSupplier verifiedDocsScorer = verifiedMatchesWeight.scorerSupplier(leafReaderContext);
                final Bits verifiedDocsBits = Lucene.asSequentialAccessBits(leafReaderContext.reader().maxDoc(), verifiedDocsScorer);
                return new BaseScorer(this, approximation, queries, PercolateQuery.this.percolatorIndexSearcher){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    boolean matchDocId(int docId) throws IOException {
                        if (verifiedDocsBits.get(docId)) {
                            return true;
                        }
                        Query query = (Query)this.percolatorQueries.apply(docId);
                        return query != null && Lucene.exists(this.percolatorIndexSearcher, query);
                    }
                };
            }
        };
    }

    public IndexSearcher getPercolatorIndexSearcher() {
        return this.percolatorIndexSearcher;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public BytesReference getDocumentSource() {
        return this.documentSource;
    }

    public QueryStore getQueryStore() {
        return this.queryStore;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString(String s) {
        return "PercolateQuery{document_type={" + this.documentType + "},document_source={" + this.documentSource.utf8ToString() + "},inner={" + this.candidateMatchesQuery.toString(s) + "}}";
    }

    @Override
    public long ramBytesUsed() {
        return this.documentSource.ramBytesUsed();
    }

    static abstract class BaseScorer
    extends Scorer {
        final Scorer approximation;
        final CheckedFunction<Integer, Query, IOException> percolatorQueries;
        final IndexSearcher percolatorIndexSearcher;

        BaseScorer(Weight weight, Scorer approximation, CheckedFunction<Integer, Query, IOException> percolatorQueries, IndexSearcher percolatorIndexSearcher) {
            super(weight);
            this.approximation = approximation;
            this.percolatorQueries = percolatorQueries;
            this.percolatorIndexSearcher = percolatorIndexSearcher;
        }

        @Override
        public final DocIdSetIterator iterator() {
            return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
        }

        @Override
        public final TwoPhaseIterator twoPhaseIterator() {
            return new TwoPhaseIterator(this.approximation.iterator()){

                @Override
                public boolean matches() throws IOException {
                    return this.matchDocId(this.approximation.docID());
                }

                @Override
                public float matchCost() {
                    return 1000.0f;
                }
            };
        }

        @Override
        public final int freq() throws IOException {
            return this.approximation.freq();
        }

        @Override
        public final int docID() {
            return this.approximation.docID();
        }

        abstract boolean matchDocId(int var1) throws IOException;
    }

    @FunctionalInterface
    static interface QueryStore {
        public CheckedFunction<Integer, Query, IOException> getQueries(LeafReaderContext var1) throws IOException;
    }
}

