/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Mustache;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.mustache.CustomMustacheFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public final class MustacheScriptEngineService
implements ScriptEngineService {
    private static final Logger logger = ESLoggerFactory.getLogger(MustacheScriptEngineService.class);
    public static final String NAME = "mustache";
    private static ThreadLocal<SoftReference<UTF8StreamWriter>> utf8StreamWriter = new ThreadLocal();
    static final SpecialPermission SPECIAL_PERMISSION = new SpecialPermission();

    private static UTF8StreamWriter utf8StreamWriter() {
        UTF8StreamWriter writer;
        SoftReference<UTF8StreamWriter> ref = utf8StreamWriter.get();
        UTF8StreamWriter uTF8StreamWriter = writer = ref == null ? null : ref.get();
        if (writer == null) {
            writer = new UTF8StreamWriter(4096);
            utf8StreamWriter.set(new SoftReference<UTF8StreamWriter>(writer));
        }
        writer.reset();
        return writer;
    }

    @Override
    public Object compile(String templateName, String templateSource, Map<String, String> params) {
        CustomMustacheFactory factory = this.createMustacheFactory(params);
        FastStringReader reader = new FastStringReader(templateSource);
        return factory.compile(reader, "query-template");
    }

    private CustomMustacheFactory createMustacheFactory(Map<String, String> params) {
        if (params == null || params.isEmpty() || !params.containsKey("content_type")) {
            return new CustomMustacheFactory();
        }
        return new CustomMustacheFactory(params.get("content_type"));
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public String getExtension() {
        return NAME;
    }

    @Override
    public ExecutableScript executable(CompiledScript compiledScript, @Nullable Map<String, Object> vars) {
        return new MustacheExecutableScript(compiledScript, vars);
    }

    @Override
    public SearchScript search(CompiledScript compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isInlineScriptEnabled() {
        return true;
    }

    private class MustacheExecutableScript
    implements ExecutableScript {
        private CompiledScript template;
        private Map<String, Object> vars;

        MustacheExecutableScript(CompiledScript template, Map<String, Object> vars) {
            this.template = template;
            this.vars = vars == null ? Collections.emptyMap() : vars;
        }

        @Override
        public void setNextVar(String name, Object value) {
            this.vars.put(name, value);
        }

        @Override
        public Object run() {
            BytesStreamOutput result = new BytesStreamOutput();
            try (UTF8StreamWriter writer = MustacheScriptEngineService.utf8StreamWriter().setOutput(result);){
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(SPECIAL_PERMISSION);
                }
                AccessController.doPrivileged(() -> {
                    ((Mustache)this.template.compiled()).execute((Writer)writer, this.vars);
                    return null;
                });
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("Error running {}", (Object)this.template), (Throwable)e);
                throw new GeneralScriptException("Error running " + this.template, e);
            }
            return result.bytes();
        }
    }
}

