/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.adjacency.InternalAdjacencyMatrix;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;

public class AdjacencyMatrixAggregator
extends BucketsAggregator {
    public static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    private final String[] keys;
    private Weight[] filters;
    private final int totalNumKeys;
    private final int totalNumIntersections;
    private final String separator;

    public AdjacencyMatrixAggregator(String name, AggregatorFactories factories, String separator, String[] keys, Weight[] filters, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.separator = separator;
        this.keys = keys;
        this.filters = filters;
        this.totalNumIntersections = (keys.length * keys.length - keys.length) / 2;
        this.totalNumKeys = keys.length + this.totalNumIntersections;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final Bits[] bits = new Bits[this.filters.length + this.totalNumIntersections];
        for (int i = 0; i < this.filters.length; ++i) {
            bits[i] = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.filters[i].scorerSupplier(ctx));
        }
        int pos = this.filters.length;
        for (int i = 0; i < this.filters.length; ++i) {
            for (int j = i + 1; j < this.filters.length; ++j) {
                bits[pos++] = new BitsIntersector(bits[i], bits[j]);
            }
        }
        assert (pos == bits.length);
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                for (int i = 0; i < bits.length; ++i) {
                    if (!bits[i].get(doc)) continue;
                    AdjacencyMatrixAggregator.this.collectBucket(sub, doc, AdjacencyMatrixAggregator.this.bucketOrd(bucket, i));
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        ArrayList<InternalAdjacencyMatrix.InternalBucket> buckets = new ArrayList<InternalAdjacencyMatrix.InternalBucket>(this.filters.length);
        for (int i = 0; i < this.keys.length; ++i) {
            long bucketOrd = this.bucketOrd(owningBucketOrdinal, i);
            int docCount = this.bucketDocCount(bucketOrd);
            if (docCount <= 0) continue;
            InternalAdjacencyMatrix.InternalBucket bucket = new InternalAdjacencyMatrix.InternalBucket(this.keys[i], docCount, this.bucketAggregations(bucketOrd));
            buckets.add(bucket);
        }
        int pos = this.keys.length;
        for (int i = 0; i < this.keys.length; ++i) {
            for (int j = i + 1; j < this.keys.length; ++j) {
                long bucketOrd = this.bucketOrd(owningBucketOrdinal, pos);
                int docCount = this.bucketDocCount(bucketOrd);
                if (docCount > 0) {
                    String intersectKey = this.keys[i] + this.separator + this.keys[j];
                    InternalAdjacencyMatrix.InternalBucket bucket = new InternalAdjacencyMatrix.InternalBucket(intersectKey, docCount, this.bucketAggregations(bucketOrd));
                    buckets.add(bucket);
                }
                ++pos;
            }
        }
        return new InternalAdjacencyMatrix(this.name, buckets, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        ArrayList<InternalAdjacencyMatrix.InternalBucket> buckets = new ArrayList<InternalAdjacencyMatrix.InternalBucket>(0);
        return new InternalAdjacencyMatrix(this.name, buckets, this.pipelineAggregators(), this.metaData());
    }

    final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
        return owningBucketOrdinal * (long)this.totalNumKeys + (long)filterOrd;
    }

    private static class BitsIntersector
    implements Bits {
        Bits a;
        Bits b;

        BitsIntersector(Bits a, Bits b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean get(int index) {
            return this.a.get(index) && this.b.get(index);
        }

        @Override
        public int length() {
            return Math.min(this.a.length(), this.b.length());
        }
    }

    protected static class KeyedFilter
    implements Writeable,
    ToXContent {
        private final String key;
        private final QueryBuilder filter;
        public static final ObjectParser.NamedObjectParser<KeyedFilter, QueryParseContext> PARSER = (p, c, name) -> new KeyedFilter(name, c.parseInnerQueryBuilder().get());

        public KeyedFilter(String key, QueryBuilder filter) {
            if (key == null) {
                throw new IllegalArgumentException("[key] must not be null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("[filter] must not be null");
            }
            this.key = key;
            this.filter = filter;
        }

        public KeyedFilter(StreamInput in) throws IOException {
            this.key = in.readString();
            this.filter = in.readNamedWriteable(QueryBuilder.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeNamedWriteable(this.filter);
        }

        public String key() {
            return this.key;
        }

        public QueryBuilder filter() {
            return this.filter;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.key, this.filter);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyedFilter other = (KeyedFilter)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.filter, other.filter);
        }
    }
}

